<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GeneralSetting;
use App\Models\ThemeSetting;
use App\Models\QuerySetting;
use App\Models\SocialMedia;
use App\Models\SiteContent;

class SettingController extends Controller
{
    //
    public function generalSetting()
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'General Settings'
        ];
        $generalsettings = GeneralSetting::find(1);
        return view('admin.pages.settings.general-settings',get_defined_vars());
    }

    public function storeSetting(Request $request)
    {
        // dd($request);
        $generalsettings = new GeneralSetting();
        
           
            
            if($request->hasFile('main_logo')){
                $file = $request->file('main_logo');
                $main_logo = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$main_logo);
                $generalsettings->main_logo = $main_logo;
    
            }    
            if($request->hasFile('footer_logo')){
                $file = $request->file('footer_logo');
                $footer_logo = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$footer_logo);
                $generalsettings->footer_logo = $footer_logo;
    
            }  
            if($request->hasFile('favicon')){
                $file = $request->file('favicon');
                $favicon = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$favicon);
                $generalsettings->favicon = $favicon;
    
            }  
            $generalsettings->site_title = $request->site_title;
            $generalsettings->meta_title = $request->meta_title;
            $generalsettings->meta_tags = $request->meta_tags;
            $generalsettings->meta_description = $request->meta_description;
            $generalsettings->description = $request->description;
            $generalsettings->disclaimer = $request->disclaimer;
            $generalsettings->meta_keywords = $request->meta_keywords;
        if( $generalsettings->save() ){
            return back()->with('success','Settings Added Successfully');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
        
    }

    public function UpdateSetting(Request $request)
    {
        // dd($request);
        $generalsettings = GeneralSetting::find($request->id);
        
        
            if($request->hasFile('main_logo')){
                $file = $request->file('main_logo');
                $main_logo = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$main_logo);
                $generalsettings->main_logo = $main_logo;
    
            }    
            if($request->hasFile('footer_logo')){
                $file = $request->file('footer_logo');
                $footer_logo = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$footer_logo);
                $generalsettings->footer_logo = $footer_logo;
    
            }  
            if($request->hasFile('favicon')){
                $file = $request->file('favicon');
                $favicon = uniqid().'.'.$file->guessExtension();
                $image_path = $file->move(public_path().'/admin-assets/images/logos/',$favicon);
                $generalsettings->favicon = $favicon;
    
            }  
           
            $generalsettings->site_title = $request->site_title;
            $generalsettings->meta_title = $request->meta_title;
            $generalsettings->meta_tags = $request->meta_tags;
            $generalsettings->meta_description = $request->meta_description;
            $generalsettings->description = $request->description;
            $generalsettings->disclaimer = $request->disclaimer;
            $generalsettings->meta_keywords = $request->meta_keywords;
            if( $generalsettings->save() ){
                return back()->with('success','Settings Updated Successfully');
            }
            else{
                return back()->with('error','Something went wrong!');
            }
    }

    public function themeSetting()
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Theme Settings'
        ];
        $themesettings = ThemeSetting::find(1);
        return view('admin.pages.settings.theme-settings',get_defined_vars());
    }

    public function storeThemeSetting(Request $request)
    {
        // dd($request);
        $themesettings = new ThemeSetting;
        if($request->hasFile('header_image')){
            $file = $request->file('header_image');
            $header_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$header_image);
            $themesettings->header_image = $header_image;

        }  
        if($request->hasFile('footer_image')){
            $file = $request->file('footer_image');
            $footer_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$footer_image);
            $themesettings->footer_image = $footer_image;

        }  
        if($request->hasFile('login_image')){
            $file = $request->file('login_image');
            $login_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$login_image);
            $themesettings->login_image = $login_image;

        }  
            $themesettings->header_type = $request->header_type;
            $themesettings->header_single_color = $request->header_single_color;
            $themesettings->header_gradient_color1 = $request->header_gradient_color1;
            $themesettings->header_gradient_color2 = $request->header_gradient_color2;
            $themesettings->header_gradient_direction = $request->header_gradient_direction;
            $themesettings->footer_type = $request->footer_type;
            $themesettings->footer_single_color = $request->footer_single_color;
            $themesettings->footer_gradient_color1 = $request->footer_gradient_color1;
            $themesettings->footer_gradient_color2 = $request->footer_gradient_color2;
            $themesettings->footer_gradient_direction = $request->footer_gradient_direction;
            $themesettings->login_type = $request->login_type;
            $themesettings->login_single_color = $request->login_single_color;
            $themesettings->login_gradient_color1 = $request->login_gradient_color1;
            $themesettings->footer_gradient_color2 = $request->login_gradient_color2;
            $themesettings->login_gradient_direction = $request->login_gradient_direction;
        if( $themesettings->save() ){
            return back()->with('success','Settings Added Successfully');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
        
    }
    public function updateThemeSetting(Request $request)
    {
        // dd($request);
        $themesettings = ThemeSetting::find($request->id);
        if($request->hasFile('header_image')){
            $file = $request->file('header_image');
            $header_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$header_image);
            $themesettings->header_image = $header_image;

        }  
        if($request->hasFile('footer_image')){
            $file = $request->file('footer_image');
            $footer_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$footer_image);
            $themesettings->footer_image = $footer_image;

        }  
        if($request->hasFile('login_image')){
            $file = $request->file('login_image');
            $login_image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/assets/images/theme/',$login_image);
            $themesettings->login_image = $login_image;

        }  
            $themesettings->header_type = $request->header_type;
            $themesettings->header_single_color = $request->header_single_color;
            $themesettings->header_gradient_color1 = $request->header_gradient_color1;
            $themesettings->header_gradient_color2 = $request->header_gradient_color2;
            $themesettings->header_gradient_direction = $request->header_gradient_direction;
            $themesettings->footer_type = $request->footer_type;
            $themesettings->footer_single_color = $request->footer_single_color;
            $themesettings->footer_gradient_color1 = $request->footer_gradient_color1;
            $themesettings->footer_gradient_color2 = $request->footer_gradient_color2;
            $themesettings->footer_gradient_direction = $request->footer_gradient_direction;
            $themesettings->login_type = $request->login_type;
            $themesettings->login_single_color = $request->login_single_color;
            $themesettings->login_gradient_color1 = $request->login_gradient_color1;
            $themesettings->login_gradient_color2 = $request->login_gradient_color2;
            $themesettings->login_gradient_direction = $request->login_gradient_direction;
        if( $themesettings->save() ){
            return back()->with('success','Settings Updated Successfully');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
        
    }

    public function QuerySetting()
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Query Settings'
        ];
        $querysettings = QuerySetting::find(1);
        return view('admin.pages.settings.query-settings',get_defined_vars());
    }

    public function storeQuerySetting(Request $request)
    {
        $querysettings = new QuerySetting;
        $querysettings->homepage_stores = $request->homepage_stores;
        $querysettings->homepage_stores_limit = $request->homepage_stores_limit;
        $querysettings->homepage_stores_orderby_key1 = $request->homepage_stores_orderby_key1;
        $querysettings->homepage_stores_orderby_key2 = $request->homepage_stores_orderby_key2;
        $querysettings->homepage_categories = $request->homepage_categories;
        $querysettings->homepage_categories_limit = $request->homepage_categories_limit;
        $querysettings->homepage_categories_orderby_key1 = $request->homepage_categories_orderby_key1;
        $querysettings->homepage_categories_orderby_key2 = $request->homepage_categories_orderby_key2;
        $querysettings->homepage_coupons = $request->homepage_coupons;
        $querysettings->homepage_coupons_limit = $request->homepage_coupons_limit;
        $querysettings->homepage_coupons_orderby_key1 = $request->homepage_coupons_orderby_key1;
        $querysettings->homepage_coupons_orderby_key2 = $request->homepage_coupons_orderby_key2;
        $querysettings->homepage_blogs = $request->homepage_blogs;
        $querysettings->homepage_blogs_limit = $request->homepage_blogs_limit;
        $querysettings->homepage_blogs_orderby_key1 = $request->homepage_blogs_orderby_key1;
        $querysettings->homepage_blogs_orderby_key2 = $request->homepage_blogs_orderby_key2;
        $querysettings->storepage_stores = $request->storepage_stores;
        $querysettings->storepage_stores_limit = $request->storepage_stores_limit;
        $querysettings->storepage_stores_orderby_key1 = $request->storepage_stores_orderby_key1;
        $querysettings->storepage_stores_orderby_key2 = $request->storepage_stores_orderby_key2;
        $querysettings->storepage_coupons = $request->storepage_coupons;
        $querysettings->storepage_coupons_limit = $request->storepage_coupons_limit;
        $querysettings->storepage_coupons_orderby_key1 = $request->storepage_coupons_orderby_key1;
        $querysettings->storepage_coupons_orderby_key2 = $request->storepage_coupons_orderby_key2;
        $querysettings->storepage_categories = $request->storepage_categories;
        $querysettings->storepage_categories_limit = $request->storepage_categories_limit;
        $querysettings->storepage_categories_orderby_key1 = $request->storepage_categories_orderby_key1;
        $querysettings->storepage_categories_orderby_key2 = $request->storepage_categories_orderby_key2;
        $querysettings->storepage_blogs = $request->storepage_blogs;
        $querysettings->storepage_blogs_limit = $request->storepage_blogs_limit;
        $querysettings->storepage_blogs_orderby_key1 = $request->storepage_blogs_orderby_key1;
        $querysettings->storepage_blogs_orderby_key2 = $request->storepage_blogs_orderby_key2;
        $querysettings->categorypage_stores = $request->categorypage_stores;
        $querysettings->categorypage_stores_limit = $request->categorypage_stores_limit;
        $querysettings->categorypage_stores_orderby_key1 = $request->categorypage_stores_orderby_key1;
        $querysettings->categorypage_stores_orderby_key2 = $request->categorypage_stores_orderby_key2;
        $querysettings->categorypage_coupons = $request->categorypage_coupons;
        $querysettings->categorypage_coupons_limit = $request->categorypage_coupons_limit;
        $querysettings->categorypage_coupons_orderby_key1 = $request->categorypage_coupons_orderby_key1;
        $querysettings->categorypage_coupons_orderby_key2 = $request->categorypage_coupons_orderby_key2;
        $querysettings->categorypage_categories = $request->categorypage_categories;
        $querysettings->categorypage_categories_limit = $request->categorypage_categories_limit;
        $querysettings->categorypage_categories_orderby_key1 = $request->categorypage_categories_orderby_key1;
        $querysettings->categorypage_categories_orderby_key2 = $request->categorypage_categories_orderby_key2;
        $querysettings->categorypage_blogs = $request->categorypage_blogs;
        $querysettings->categorypage_blogs_limit = $request->categorypage_blogs_limit;
        $querysettings->categorypage_blogs_orderby_key1 = $request->categorypage_blogs_orderby_key1;
        $querysettings->categorypage_blogs_orderby_key2 = $request->categorypage_blogs_orderby_key2;
        $querysettings->blogpage_stores = $request->blogpage_stores;
        $querysettings->blogpage_stores_limit = $request->blogpage_stores_limit;
        $querysettings->blogpage_stores_orderby_key1 = $request->blogpage_stores_orderby_key1;
        $querysettings->blogpage_stores_orderby_key2 = $request->blogpage_stores_orderby_key2;
        $querysettings->blogpage_coupons = $request->blogpage_coupons;
        $querysettings->blogpage_coupons_limit = $request->blogpage_coupons_limit;
        $querysettings->blogpage_coupons_orderby_key1 = $request->blogpage_coupons_orderby_key1;
        $querysettings->blogpage_coupons_orderby_key2 = $request->blogpage_coupons_orderby_key2;
        $querysettings->blogpage_categories = $request->blogpage_categories;
        $querysettings->blogpage_categories_limit = $request->blogpage_categories_limit;
        $querysettings->blogpage_categories_orderby_key1 = $request->blogpage_categories_orderby_key1;
        $querysettings->blogpage_categories_orderby_key2 = $request->blogpage_categories_orderby_key2;
        $querysettings->blogpage_blogs = $request->blogpage_blogs;
        $querysettings->blogpage_blogs_limit = $request->blogpage_blogs_limit;
        $querysettings->blogpage_blogs_orderby_key1 = $request->blogpage_blogs_orderby_key1;
        $querysettings->blogpage_blogs_orderby_key2 = $request->blogpage_blogs_orderby_key2;
        $querysettings->eventpage_stores = $request->eventpage_stores;
        $querysettings->eventpage_stores_limit = $request->eventpage_stores_limit;
        $querysettings->eventpage_stores_orderby_key1 = $request->eventpage_stores_orderby_key1;
        $querysettings->eventpage_stores_orderby_key2 = $request->eventpage_stores_orderby_key2;
        $querysettings->eventpage_coupons = $request->eventpage_coupons;
        $querysettings->eventpage_coupons_limit = $request->eventpage_coupons_limit;
        $querysettings->eventpage_coupons_orderby_key1 = $request->eventpage_coupons_orderby_key1;
        $querysettings->eventpage_coupons_orderby_key2 = $request->eventpage_coupons_orderby_key2;
        $querysettings->eventpage_categories = $request->eventpage_categories;
        $querysettings->eventpage_categories_limit = $request->eventpage_categories_limit;
        $querysettings->eventpage_categories_orderby_key1 = $request->eventpage_categories_orderby_key1;
        $querysettings->eventpage_categories_orderby_key2 = $request->eventpage_categories_orderby_key2;
        $querysettings->eventpage_blogs = $request->eventpage_blogs;
        $querysettings->eventpage_blogs_limit = $request->eventpage_blogs_limit;
        $querysettings->eventpage_blogs_orderby_key1 = $request->eventpage_blogs_orderby_key1;
        $querysettings->eventpage_blogs_orderby_key2 = $request->eventpage_blogs_orderby_key2;
        $querysettings->storeprofilepage_stores = $request->storeprofilepage_stores;
        $querysettings->storeprofilepage_stores_limit = $request->storeprofilepage_stores_limit;
        $querysettings->storeprofilepage_stores_orderby_key1 = $request->storeprofilepage_stores_orderby_key1;
        $querysettings->storeprofilepage_stores_orderby_key2 = $request->storeprofilepage_stores_orderby_key2;
        $querysettings->storeprofilepage_coupons = $request->storeprofilepage_coupons;
        $querysettings->storeprofilepage_coupons_limit = $request->storeprofilepage_coupons_limit;
        $querysettings->storeprofilepage_coupons_orderby_key1 = $request->storeprofilepage_coupons_orderby_key1;
        $querysettings->storeprofilepage_coupons_orderby_key2 = $request->storeprofilepage_coupons_orderby_key2;
        $querysettings->storeprofilepage_categories = $request->storeprofilepage_categories;
        $querysettings->storeprofilepage_categories_limit = $request->storeprofilepage_categories_limit;
        $querysettings->storeprofilepage_categories_orderby_key1 = $request->storeprofilepage_categories_orderby_key1;
        $querysettings->storeprofilepage_categories_orderby_key2 = $request->storeprofilepage_categories_orderby_key2;
        $querysettings->storeprofilepage_blogs = $request->storeprofilepage_blogs;
        $querysettings->storeprofilepage_blogs_limit = $request->storeprofilepage_blogs_limit;
        $querysettings->storeprofilepage_blogs_orderby_key1 = $request->storeprofilepage_blogs_orderby_key1;
        $querysettings->storeprofilepage_blogs_orderby_key2 = $request->storeprofilepage_blogs_orderby_key2;
        $querysettings->categoryprofilepage_stores = $request->categoryprofilepage_stores;
        $querysettings->categoryprofilepage_stores_limit = $request->categoryprofilepage_stores_limit;
        $querysettings->categoryprofilepage_stores_orderby_key1 = $request->categoryprofilepage_stores_orderby_key1;
        $querysettings->categoryprofilepage_stores_orderby_key2 = $request->categoryprofilepage_stores_orderby_key2;
        $querysettings->categoryprofilepage_coupons = $request->categoryprofilepage_coupons;
        $querysettings->categoryprofilepage_coupons_limit = $request->categoryprofilepage_coupons_limit;
        $querysettings->categoryprofilepage_coupons_orderby_key1 = $request->categoryprofilepage_coupons_orderby_key1;
        $querysettings->categoryprofilepage_coupons_orderby_key2 = $request->categoryprofilepage_coupons_orderby_key2;
        $querysettings->categoryprofilepage_categories = $request->categoryprofilepage_categories;
        $querysettings->categoryprofilepage_categories_limit = $request->categoryprofilepage_categories_limit;
        $querysettings->categoryprofilepage_categories_orderby_key1 = $request->categoryprofilepage_categories_orderby_key1;
        $querysettings->categoryprofilepage_categories_orderby_key2 = $request->categoryprofilepage_categories_orderby_key2;
        $querysettings->categoryprofilepage_blogs = $request->categoryprofilepage_blogs;
        $querysettings->categoryprofilepage_blogs_limit = $request->categoryprofilepage_blogs_limit;
        $querysettings->categoryprofilepage_blogs_orderby_key1 = $request->categoryprofilepage_blogs_orderby_key1;
        $querysettings->categoryprofilepage_blogs_orderby_key2 = $request->categoryprofilepage_blogs_orderby_key2;
        $querysettings->blogpage_stores = $request->blogprofilepage_stores;
        $querysettings->blogprofilepage_stores_limit = $request->blogprofilepage_stores_limit;
        $querysettings->blogprofilepage_stores_orderby_key1 = $request->blogprofilepage_stores_orderby_key1;
        $querysettings->blogprofilepage_stores_orderby_key2 = $request->blogprofilepage_stores_orderby_key2;
        $querysettings->blogprofilepage_coupons = $request->blogprofilepage_coupons;
        $querysettings->blogprofilepage_coupons_limit = $request->blogprofilepage_coupons_limit;
        $querysettings->blogprofilepage_coupons_orderby_key1 = $request->blogprofilepage_coupons_orderby_key1;
        $querysettings->blogprofilepage_coupons_orderby_key2 = $request->blogprofilepage_coupons_orderby_key2;
        $querysettings->blogprofilepage_categories = $request->blogprofilepage_categories;
        $querysettings->blogprofilepage_categories_limit = $request->blogprofilepage_categories_limit;
        $querysettings->blogprofilepage_categories_orderby_key1 = $request->blogprofilepage_categories_orderby_key1;
        $querysettings->blogprofilepage_categories_orderby_key2 = $request->blogprofilepage_categories_orderby_key2;
        $querysettings->blogprofilepage_blogs = $request->blogprofilepage_blogs;
        $querysettings->blogprofilepage_blogs_limit = $request->blogprofilepage_blogs_limit;
        $querysettings->blogprofilepage_blogs_orderby_key1 = $request->blogprofilepage_blogs_orderby_key1;
        $querysettings->blogprofilepage_blogs_orderby_key2 = $request->blogprofilepage_blogs_orderby_key2;
        $querysettings->eventprofilepage_stores = $request->eventprofilepage_stores;
        $querysettings->eventprofilepage_stores_limit = $request->evenprofiletpage_stores_limit;
        $querysettings->eventprofilepage_stores_orderby_key1 = $request->eventprofilepage_stores_orderby_key1;
        $querysettings->eventprofilepage_stores_orderby_key2 = $request->eventprofilepage_stores_orderby_key2;
        $querysettings->eventprofilepage_coupons = $request->eventprofilepage_coupons;
        $querysettings->eventprofilepage_coupons_limit = $request->eventprofilepage_coupons_limit;
        $querysettings->eventprofilepage_coupons_orderby_key1 = $request->eventprofilepage_coupons_orderby_key1;
        $querysettings->eventprofilepage_coupons_orderby_key2 = $request->eventprofilepage_coupons_orderby_key2;
        $querysettings->eventprofilepage_categories = $request->eventprofilepage_categories;
        $querysettings->eventprofilepage_categories_limit = $request->eventprofilepage_categories_limit;
        $querysettings->eventprofilepage_categories_orderby_key1 = $request->eventprofilepage_categories_orderby_key1;
        $querysettings->eventprofilepage_categories_orderby_key2 = $request->eventprofilepage_categories_orderby_key2;
        $querysettings->eventprofilepage_blogs = $request->eventprofilepage_blogs;
        $querysettings->eventprofilepage_blogs_limit = $request->eventprofilepage_blogs_limit;
        $querysettings->eventprofilepage_blogs_orderby_key1 = $request->eventprofilepage_blogs_orderby_key1;
        $querysettings->eventprofilepage_blogs_orderby_key2 = $request->eventprofilepage_blogs_orderby_key2;
        $querysettings->footer_stores = $request->footer_stores;
        $querysettings->footer_stores_limit = $request->footer_stores_limit;
        $querysettings->footer_stores_orderby_key1 = $request->footer_stores_orderby_key1;
        $querysettings->footer_stores_orderby_key2 = $request->footer_stores_orderby_key2;
        $querysettings->footer_categories = $request->footer_categories;
        $querysettings->footer_categories_limit = $request->footer_categories_limit;
        $querysettings->footer_categories_orderby_key1 = $request->footer_categories_orderby_key1;
        $querysettings->footer_categories_orderby_key2 = $request->footer_categories_orderby_key2;
        $querysettings->footer_blogs = $request->footer_blogs;
        $querysettings->footer_blogs_limit = $request->footer_blogs_limit;
        $querysettings->footer_blogs_orderby_key1 = $request->footer_blogs_orderby_key1;
        $querysettings->footer_blogs_orderby_key2 = $request->footer_blogs_orderby_key2;

        if($querysettings->save())
        {
            return back()->with('success','Settings Added Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }

    public function updateQuerySetting(Request $request)
    {
        $querysettings = QuerySetting::find($request->id);
        $querysettings->homepage_stores = $request->homepage_stores;
        $querysettings->homepage_stores_limit = $request->homepage_stores_limit;
        $querysettings->homepage_stores_orderby_key1 = $request->homepage_stores_orderby_key1;
        $querysettings->homepage_stores_orderby_key2 = $request->homepage_stores_orderby_key2;
        $querysettings->homepage_categories = $request->homepage_categories;
        $querysettings->homepage_categories_limit = $request->homepage_categories_limit;
        $querysettings->homepage_categories_orderby_key1 = $request->homepage_categories_orderby_key1;
        $querysettings->homepage_categories_orderby_key2 = $request->homepage_categories_orderby_key2;
        $querysettings->homepage_coupons = $request->homepage_coupons;
        $querysettings->homepage_coupons_limit = $request->homepage_coupons_limit;
        $querysettings->homepage_coupons_orderby_key1 = $request->homepage_coupons_orderby_key1;
        $querysettings->homepage_coupons_orderby_key2 = $request->homepage_coupons_orderby_key2;
        $querysettings->homepage_blogs = $request->homepage_blogs;
        $querysettings->homepage_blogs_limit = $request->homepage_blogs_limit;
        $querysettings->homepage_blogs_orderby_key1 = $request->homepage_blogs_orderby_key1;
        $querysettings->homepage_blogs_orderby_key2 = $request->homepage_blogs_orderby_key2;
        $querysettings->storepage_stores = $request->storepage_stores;
        $querysettings->storepage_stores_limit = $request->storepage_stores_limit;
        $querysettings->storepage_stores_orderby_key1 = $request->storepage_stores_orderby_key1;
        $querysettings->storepage_stores_orderby_key2 = $request->storepage_stores_orderby_key2;
        $querysettings->storepage_coupons = $request->storepage_coupons;
        $querysettings->storepage_coupons_limit = $request->storepage_coupons_limit;
        $querysettings->storepage_coupons_orderby_key1 = $request->storepage_coupons_orderby_key1;
        $querysettings->storepage_coupons_orderby_key2 = $request->storepage_coupons_orderby_key2;
        $querysettings->storepage_categories = $request->storepage_categories;
        $querysettings->storepage_categories_limit = $request->storepage_categories_limit;
        $querysettings->storepage_categories_orderby_key1 = $request->storepage_categories_orderby_key1;
        $querysettings->storepage_categories_orderby_key2 = $request->storepage_categories_orderby_key2;
        $querysettings->storepage_blogs = $request->storepage_blogs;
        $querysettings->storepage_blogs_limit = $request->storepage_blogs_limit;
        $querysettings->storepage_blogs_orderby_key1 = $request->storepage_blogs_orderby_key1;
        $querysettings->storepage_blogs_orderby_key2 = $request->storepage_blogs_orderby_key2;
        $querysettings->categorypage_stores = $request->categorypage_stores;
        $querysettings->categorypage_stores_limit = $request->categorypage_stores_limit;
        $querysettings->categorypage_stores_orderby_key1 = $request->categorypage_stores_orderby_key1;
        $querysettings->categorypage_stores_orderby_key2 = $request->categorypage_stores_orderby_key2;
        $querysettings->categorypage_coupons = $request->categorypage_coupons;
        $querysettings->categorypage_coupons_limit = $request->categorypage_coupons_limit;
        $querysettings->categorypage_coupons_orderby_key1 = $request->categorypage_coupons_orderby_key1;
        $querysettings->categorypage_coupons_orderby_key2 = $request->categorypage_coupons_orderby_key2;
        $querysettings->categorypage_categories = $request->categorypage_categories;
        $querysettings->categorypage_categories_limit = $request->categorypage_categories_limit;
        $querysettings->categorypage_categories_orderby_key1 = $request->categorypage_categories_orderby_key1;
        $querysettings->categorypage_categories_orderby_key2 = $request->categorypage_categories_orderby_key2;
        $querysettings->categorypage_blogs = $request->categorypage_blogs;
        $querysettings->categorypage_blogs_limit = $request->categorypage_blogs_limit;
        $querysettings->categorypage_blogs_orderby_key1 = $request->categorypage_blogs_orderby_key1;
        $querysettings->categorypage_blogs_orderby_key2 = $request->categorypage_blogs_orderby_key2;
        $querysettings->blogpage_stores = $request->blogpage_stores;
        $querysettings->blogpage_stores_limit = $request->blogpage_stores_limit;
        $querysettings->blogpage_stores_orderby_key1 = $request->blogpage_stores_orderby_key1;
        $querysettings->blogpage_stores_orderby_key2 = $request->blogpage_stores_orderby_key2;
        $querysettings->blogpage_coupons = $request->blogpage_coupons;
        $querysettings->blogpage_coupons_limit = $request->blogpage_coupons_limit;
        $querysettings->blogpage_coupons_orderby_key1 = $request->blogpage_coupons_orderby_key1;
        $querysettings->blogpage_coupons_orderby_key2 = $request->blogpage_coupons_orderby_key2;
        $querysettings->blogpage_categories = $request->blogpage_categories;
        $querysettings->blogpage_categories_limit = $request->blogpage_categories_limit;
        $querysettings->blogpage_categories_orderby_key1 = $request->blogpage_categories_orderby_key1;
        $querysettings->blogpage_categories_orderby_key2 = $request->blogpage_categories_orderby_key2;
        $querysettings->blogpage_blogs = $request->blogpage_blogs;
        $querysettings->blogpage_blogs_limit = $request->blogpage_blogs_limit;
        $querysettings->blogpage_blogs_orderby_key1 = $request->blogpage_blogs_orderby_key1;
        $querysettings->blogpage_blogs_orderby_key2 = $request->blogpage_blogs_orderby_key2;
        $querysettings->eventpage_stores = $request->eventpage_stores;
        $querysettings->eventpage_stores_limit = $request->eventpage_stores_limit;
        $querysettings->eventpage_stores_orderby_key1 = $request->eventpage_stores_orderby_key1;
        $querysettings->eventpage_stores_orderby_key2 = $request->eventpage_stores_orderby_key2;
        $querysettings->eventpage_coupons = $request->eventpage_coupons;
        $querysettings->eventpage_coupons_limit = $request->eventpage_coupons_limit;
        $querysettings->eventpage_coupons_orderby_key1 = $request->eventpage_coupons_orderby_key1;
        $querysettings->eventpage_coupons_orderby_key2 = $request->eventpage_coupons_orderby_key2;
        $querysettings->eventpage_categories = $request->eventpage_categories;
        $querysettings->eventpage_categories_limit = $request->eventpage_categories_limit;
        $querysettings->eventpage_categories_orderby_key1 = $request->eventpage_categories_orderby_key1;
        $querysettings->eventpage_categories_orderby_key2 = $request->eventpage_categories_orderby_key2;
        $querysettings->eventpage_blogs = $request->eventpage_blogs;
        $querysettings->eventpage_blogs_limit = $request->eventpage_blogs_limit;
        $querysettings->eventpage_blogs_orderby_key1 = $request->eventpage_blogs_orderby_key1;
        $querysettings->eventpage_blogs_orderby_key2 = $request->eventpage_blogs_orderby_key2;
        $querysettings->storeprofilepage_stores = $request->storeprofilepage_stores;
        $querysettings->storeprofilepage_stores_limit = $request->storeprofilepage_stores_limit;
        $querysettings->storeprofilepage_stores_orderby_key1 = $request->storeprofilepage_stores_orderby_key1;
        $querysettings->storeprofilepage_stores_orderby_key2 = $request->storeprofilepage_stores_orderby_key2;
        $querysettings->storeprofilepage_coupons = $request->storeprofilepage_coupons;
        $querysettings->storeprofilepage_coupons_limit = $request->storeprofilepage_coupons_limit;
        $querysettings->storeprofilepage_coupons_orderby_key1 = $request->storeprofilepage_coupons_orderby_key1;
        $querysettings->storeprofilepage_coupons_orderby_key2 = $request->storeprofilepage_coupons_orderby_key2;
        $querysettings->storeprofilepage_categories = $request->storeprofilepage_categories;
        $querysettings->storeprofilepage_categories_limit = $request->storeprofilepage_categories_limit;
        $querysettings->storeprofilepage_categories_orderby_key1 = $request->storeprofilepage_categories_orderby_key1;
        $querysettings->storeprofilepage_categories_orderby_key2 = $request->storeprofilepage_categories_orderby_key2;
        $querysettings->storeprofilepage_blogs = $request->storeprofilepage_blogs;
        $querysettings->storeprofilepage_blogs_limit = $request->storeprofilepage_blogs_limit;
        $querysettings->storeprofilepage_blogs_orderby_key1 = $request->storeprofilepage_blogs_orderby_key1;
        $querysettings->storeprofilepage_blogs_orderby_key2 = $request->storeprofilepage_blogs_orderby_key2;
        $querysettings->categoryprofilepage_stores = $request->categoryprofilepage_stores;
        $querysettings->categoryprofilepage_stores_limit = $request->categoryprofilepage_stores_limit;
        $querysettings->categoryprofilepage_stores_orderby_key1 = $request->categoryprofilepage_stores_orderby_key1;
        $querysettings->categoryprofilepage_stores_orderby_key2 = $request->categoryprofilepage_stores_orderby_key2;
        $querysettings->categoryprofilepage_coupons = $request->categoryprofilepage_coupons;
        $querysettings->categoryprofilepage_coupons_limit = $request->categoryprofilepage_coupons_limit;
        $querysettings->categoryprofilepage_coupons_orderby_key1 = $request->categoryprofilepage_coupons_orderby_key1;
        $querysettings->categoryprofilepage_coupons_orderby_key2 = $request->categoryprofilepage_coupons_orderby_key2;
        $querysettings->categoryprofilepage_categories = $request->categoryprofilepage_categories;
        $querysettings->categoryprofilepage_categories_limit = $request->categoryprofilepage_categories_limit;
        $querysettings->categoryprofilepage_categories_orderby_key1 = $request->categoryprofilepage_categories_orderby_key1;
        $querysettings->categoryprofilepage_categories_orderby_key2 = $request->categoryprofilepage_categories_orderby_key2;
        $querysettings->categoryprofilepage_blogs = $request->categoryprofilepage_blogs;
        $querysettings->categoryprofilepage_blogs_limit = $request->categoryprofilepage_blogs_limit;
        $querysettings->categoryprofilepage_blogs_orderby_key1 = $request->categoryprofilepage_blogs_orderby_key1;
        $querysettings->categoryprofilepage_blogs_orderby_key2 = $request->categoryprofilepage_blogs_orderby_key2;
        $querysettings->blogpage_stores = $request->blogprofilepage_stores;
        $querysettings->blogprofilepage_stores_limit = $request->blogprofilepage_stores_limit;
        $querysettings->blogprofilepage_stores_orderby_key1 = $request->blogprofilepage_stores_orderby_key1;
        $querysettings->blogprofilepage_stores_orderby_key2 = $request->blogprofilepage_stores_orderby_key2;
        $querysettings->blogprofilepage_coupons = $request->blogprofilepage_coupons;
        $querysettings->blogprofilepage_coupons_limit = $request->blogprofilepage_coupons_limit;
        $querysettings->blogprofilepage_coupons_orderby_key1 = $request->blogprofilepage_coupons_orderby_key1;
        $querysettings->blogprofilepage_coupons_orderby_key2 = $request->blogprofilepage_coupons_orderby_key2;
        $querysettings->blogprofilepage_categories = $request->blogprofilepage_categories;
        $querysettings->blogprofilepage_categories_limit = $request->blogprofilepage_categories_limit;
        $querysettings->blogprofilepage_categories_orderby_key1 = $request->blogprofilepage_categories_orderby_key1;
        $querysettings->blogprofilepage_categories_orderby_key2 = $request->blogprofilepage_categories_orderby_key2;
        $querysettings->blogprofilepage_blogs = $request->blogprofilepage_blogs;
        $querysettings->blogprofilepage_blogs_limit = $request->blogprofilepage_blogs_limit;
        $querysettings->blogprofilepage_blogs_orderby_key1 = $request->blogprofilepage_blogs_orderby_key1;
        $querysettings->blogprofilepage_blogs_orderby_key2 = $request->blogprofilepage_blogs_orderby_key2;
        $querysettings->eventprofilepage_stores = $request->eventprofilepage_stores;
        $querysettings->eventprofilepage_stores_limit = $request->evenprofiletpage_stores_limit;
        $querysettings->eventprofilepage_stores_orderby_key1 = $request->eventprofilepage_stores_orderby_key1;
        $querysettings->eventprofilepage_stores_orderby_key2 = $request->eventprofilepage_stores_orderby_key2;
        $querysettings->eventprofilepage_coupons = $request->eventprofilepage_coupons;
        $querysettings->eventprofilepage_coupons_limit = $request->eventprofilepage_coupons_limit;
        $querysettings->eventprofilepage_coupons_orderby_key1 = $request->eventprofilepage_coupons_orderby_key1;
        $querysettings->eventprofilepage_coupons_orderby_key2 = $request->eventprofilepage_coupons_orderby_key2;
        $querysettings->eventprofilepage_categories = $request->eventprofilepage_categories;
        $querysettings->eventprofilepage_categories_limit = $request->eventprofilepage_categories_limit;
        $querysettings->eventprofilepage_categories_orderby_key1 = $request->eventprofilepage_categories_orderby_key1;
        $querysettings->eventprofilepage_categories_orderby_key2 = $request->eventprofilepage_categories_orderby_key2;
        $querysettings->eventprofilepage_blogs = $request->eventprofilepage_blogs;
        $querysettings->eventprofilepage_blogs_limit = $request->eventprofilepage_blogs_limit;
        $querysettings->eventprofilepage_blogs_orderby_key1 = $request->eventprofilepage_blogs_orderby_key1;
        $querysettings->eventprofilepage_blogs_orderby_key2 = $request->eventprofilepage_blogs_orderby_key2;
        $querysettings->footer_stores = $request->footer_stores;
        $querysettings->footer_stores_limit = $request->footer_stores_limit;
        $querysettings->footer_stores_orderby_key1 = $request->footer_stores_orderby_key1;
        $querysettings->footer_stores_orderby_key2 = $request->footer_stores_orderby_key2;
        $querysettings->footer_categories = $request->footer_categories;
        $querysettings->footer_categories_limit = $request->footer_categories_limit;
        $querysettings->footer_categories_orderby_key1 = $request->footer_categories_orderby_key1;
        $querysettings->footer_categories_orderby_key2 = $request->footer_categories_orderby_key2;
        $querysettings->footer_blogs = $request->footer_blogs;
        $querysettings->footer_blogs_limit = $request->footer_blogs_limit;
        $querysettings->footer_blogs_orderby_key1 = $request->footer_blogs_orderby_key1;
        $querysettings->footer_blogs_orderby_key2 = $request->footer_blogs_orderby_key2;

        if($querysettings->update())
        {
            return back()->with('success','Settings Updated Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }
    public function AddSocialMedia()
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Add Social Media'
        ];
        return view('admin.pages.settings.add-social-media',get_defined_vars());
    }

    public function SocialMedia()
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Social Media'
        ];
        $socialmedia = SocialMedia::all();
        return view('admin.pages.settings.socialmedia-list',get_defined_vars());
    }

    public function StoreSocialMedia(Request $request)
    {
        $socialmedia = new SocialMedia;
        $socialmedia->title = $request->title;
        $socialmedia->url = $request->url;
        $socialmedia->icon = $request->icon;
        if($socialmedia->save())
        {
            return redirect()->route('social.media')->with('success','Settings Added Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }

    public function EditSocialMedia($id)
    {
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Edit Social Media'
        ];
        $socialmedia = SocialMedia::find($id);
        return view('admin.pages.settings.edit-social-media',get_defined_vars());
    }

    public function UpdateSocialMedia(Request $request)
    {
        $socialmedia = SocialMedia::find($request->id);
        $socialmedia->title = $request->title;
        $socialmedia->url = $request->url;
        $socialmedia->icon = $request->icon;
        if($socialmedia->update())
        {
            return redirect()->route('social.media')->with('success','Settings Updated Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }

    public function DelSocialMedia($id)
    {
        $socialmedia = SocialMedia::find($id);
        if($socialmedia->delete())
        {
            return back()->with('success','Media Deleted Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }

    public function SiteContent(){
        $page_data = [
            'title' => 'Settings',
            'slug'  => 'Site Content'
        ];
        $content = SiteContent::find(1);
        // dd($content);
        return view('admin.pages.settings.site-content',get_defined_vars());
    }
    public function StoreSiteContent(Request $request){
        
        $content = new SiteContent;
        $content->details = $request->details;
        if($content->save()){
        return back()->with('success','Content Added Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }

    public function UpdateSiteContent(Request $request){
        
        $content =  SiteContent::find($request->id);
        $content->details = $request->details;
        if($content->update()){
        return back()->with('success','Content Updated Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }
}
