<?php

namespace App\Http\Controllers;

use App\Models\BlogSavedByUser;
use App\Models\Comment;
use App\Models\Reply;
use App\Models\User;
use Illuminate\Http\Request;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = User::find(Auth::id());
        $comments_by_user = Comment::with(['blog','user'])->where('comments.user_id',Auth::id())->get();
        $blogs = BlogSavedByUser::with('blog')->where('blog_saved_by_users.user_id',$user->id)->paginate(10);
        return view('user.pages.user-profile',get_defined_vars());
    }

    public function EditProfile($id)
    {
        $user = User::find($id);
        return view('user.pages.edit-profile',get_defined_vars());
    }

    public function UserUpdate(Request $request)
    {
        $user = User::find(Auth::id());

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = uniqid() . '.' . $file->guessExtension();
            $image_path = $file->move(public_path() . '/admin-assets/images/users/', $image);
            $user->image = $image;

        }
        $user->name = $request->name;
        $user->email = $request->email;
        if ($user->save()) {
            return redirect()->route('dashboard')->withSuccess('User Updated Successfully!');
        } else {
            return redirect()->back()->withError('Something went wrong!');
        }
    }
}
