@extends('admin.layouts.app')
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Edit </strong> Event</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('events.update', $event->id) }}" autocomplete="off" enctype="multipart/form-data">
                        @method('patch')
                        @csrf
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Category Name"
                                value="{{ $event->name }}" name="name" required>

                        </div>
                        <label for="description">Description</label>
                        <div class="form-group">
                            <textarea id="description" class="form-control" name="description"  placeholder="Entere Event Description">{{ $event->description }}</textarea>

                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="image">

                        </div>
                        <div class="checkbox">
                            <input id="is_exclusive" type="checkbox" name="is_exclusive" value="yes" @if($event->is_exclusive == 'yes') checked @endif>
                            <label for="is_exclusive">Is Exclusive?</label>

                        </div>
                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('events.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
