@extends('admin.layouts.app')
@section('custom-styles')
<link rel="stylesheet" href="{{ asset('admin-assets/css/summernote.css') }}" />
   
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Page</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('pages.store') }}" autocomplete="off"
                        enctype="multipart/form-data">
                        
                        @csrf
                        <label for="title">Title</label>
                        <div class="form-group">
                            <input type="text" id="title" class="form-control" placeholder="Enter Page Title"
                                name="title" required>

                        </div>

                        <label> Description</label>
                        <div class="form-group">
                            <textarea class="summernote" name="details">
                                
                            
                            </textarea>
                        </div>
                        <label for="meta_title">Meta Title</label>
                        <div class="form-group">
                            <input type="text" id="meta_title" class="form-control" placeholder="Enter Meta Title"
                                name="meta_title" value="{{ old('meta_title') }}">

                        </div>
                        <label for="meta_description">Meta Description</label>
                        <div class="form-group">
                            <textarea id="meta_description" class="form-control" name="meta_description" placeholder="Entere Meta Description"></textarea>

                        </div>


                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('pages.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
    <script src="{{ asset('admin-assets/js/summernote.js') }}"></script>

    <script>
        jQuery(document).ready(function() {

            $('.summernote').summernote({
                height: 350, // set editor height
                minHeight: null, // set minimum height of editor
                maxHeight: null, // set maximum height of editor
                focus: false, // set focus to editable area after initializing summernote
                popover: {
                    image: [],
                    link: [],
                    air: []
                }
            });

            $('.inline-editor').summernote({
                airMode: true
            });

        });

        window.edit = function() {
                $(".click2edit").summernote()
            },
            window.save = function() {
                $(".click2edit").summernote('destroy');
            }
    </script>
@endsection
