@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Roles </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('roles.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Roles</a>
                        </li>
                    </ul>
                </div>

                <div class="body">
                    <div class="body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Guard</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Guard</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach ($rolePermissions as $permission)
                                        <tr>
                                            <td>{{ $permission->name }}</td>
                                            <td>{{ $permission->guard_name }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <a href="{{ route('roles.edit', $role->id) }}" class="btn btn-info">Edit</a>
                        <a href="{{ route('roles.index') }}" class="btn btn-default">Back</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
