@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>General </strong>Settings</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST"
                        action="@if ($generalsettings) {{ route('update.general.settings') }}@else {{ route('store.general.settings') }} @endif"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" value="@if ($generalsettings) {{ $generalsettings->id }} @endif"
                            name="id">
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Site Title</label>
                                <input type="text" class="form-control" name="site_title"
                                    value="@if ($generalsettings) {{ $generalsettings->site_title }} @endif">
                            </div>
                            <div class="col-6">
                                <label class="form-label">Meta Title</label>
                                <input type="text" class="form-control" name="meta_title"
                                    value="@if ($generalsettings) {{ $generalsettings->meta_title }} @endif">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description">
                                  @if ($generalsettings)
                                        {{ $generalsettings->description }}
                                        @endif
                                  </textarea>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Meta Description</label>
                                <textarea class="form-control" name="meta_description">
                                  @if ($generalsettings)
                                      {{ $generalsettings->meta_description }}
                                      @endif
                                  </textarea>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Meta Keywords</label>
                                <input type="text" class="form-control" name="meta_keywords"
                                    value="@if ($generalsettings) {{ $generalsettings->meta_keywords }} @endif">
                            </div>
                            <div class="col-6">
                                <label class="form-label">Meta Tags</label>
                                <input type="text" class="form-control" name="meta_tags"
                                    value="@if ($generalsettings) {{ $generalsettings->meta_tags }} @endif">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-8">
                                <label class="form-label">Main Logo</label>
                                <input type="file" class="form-control" name="main_logo" value="">

                            </div>
                            <div class="col-4">
                                @if ($generalsettings)
                                    <img src="{{ asset('public/assets/images/logos') }}/{{ $generalsettings->main_logo }}"
                                        alt="" width="100">
                                @endif

                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-8">
                                <label class="form-label">Footer Logo</label>
                                <input type="file" class="form-control" name="footer_logo" value="">
                            </div>
                            <div class="col-4">
                                @if ($generalsettings)
                                    <img src="{{ asset('public/assets/images/logos') }}/{{ $generalsettings->footer_logo }}"
                                        alt="" width="100">
                                @endif
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-8">
                                <label class="form-label">Favicon</label>
                                <input type="file" class="form-control" name="favicon" value="">
                            </div>
                            <div class="col-4">
                                @if ($generalsettings)
                                    <img src="{{ asset('public/assets/images/logos') }}/{{ $generalsettings->favicon }}"
                                        alt="" width="100">
                                @endif
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label">Disclaimer</label>
                                <textarea class="form-control" name="disclaimer">
                              @if ($generalsettings)
                              {{ $generalsettings->disclaimer }}
                              @endif
                              </textarea>
                            </div>
                        </div>
                        <br>
                        <div class="col-12">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
