@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Sub Category</h2>
                    
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('subcategories.store') }}" autocomplete="off" enctype="multipart/form-data">
                        @csrf
                        <label class="form-label">Parent Category</label>
                        <select class="form-control show-tick" name="category_id">
                            <option value="">--select Category--</option>
                            @foreach ($categories as $key => $category)
                            <option value="{{ $key}}">{{ $category }}</option>
                            @endforeach
                        </select>
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Category Name"
                                value="{{ old('name') }}" name="name" required>
                            
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="feature_image">
                            
                        </div>
                        <label for="logo_image">Logo Image</label>
                        <div class="form-group">
                            <input type="file" id="logo_image" class="form-control" name="logo_image">
                            
                        </div>
                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('subcategories.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

