<!-- Header (Tailwind + Blade) -->
<header class="w-full bg-[#3F51B5] shadow-md sticky top-0 z-50">
  <!-- Top Bar -->
  <div class="bg-[#FF4E8A] text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-between h-10">
      <nav class="hidden md:flex space-x-6 text-sm">
        <a href="https://postprospectors.com/topics/entertainment" class="hover:text-white">Latest News</a>
        <a href="https://postprospectors.com/topics/travel" class="hover:text-white">Travel Updates</a>
        <a href="https://postprospectors.com/info/our-company" class="hover:text-white">About Us</a>
      </nav>

      <ul class="flex space-x-4 text-lg">
        @php $social_links = \App\Models\SocialMedia::get(); @endphp
        @foreach($social_links as $link)
          <li>
            <a href="{{ $link->url }}" class="hover:text-blue-400 transition">
              <i class="fa {{ $link->title }}"></i>
            </a>
          </li>
        @endforeach
      </ul>
    </div>
  </div>

  <!-- Main Navbar -->
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex items-center justify-between h-16">
      <!-- Logo -->
      <a href="{{ route('index') }}" class="flex-shrink-0">
        <img src="@if($settings){{ asset('admin-assets/images/logos/'.$settings->main_logo) }}@endif"
             alt="Logo" class="h-10">
      </a>

      <!-- Desktop Navigation -->
      @php
        $categories = \App\Models\Category::select('id','slug','name')->limit(5)->get();
      @endphp
      <nav class="hidden md:flex space-x-6">
        <a href="{{ route('index') }}" class="hover:text-white"><i class="fa fa-home"></i></a>

        @foreach($categories as $row)
          <div class="group relative">
            <a href="{{ route('blogs.category', $row->slug) }}" class="text-white hover:text-white">
              {{ $row->name }}
            </a>

            <div class="absolute left-0 hidden group-hover:block bg-white shadow-lg rounded-md mt-2 w-48 z-50">
              <ul class="py-2">
                @php
                  $subcategories = \App\Models\SubCategory::select('id','name','slug')
                      ->where('category_id', $row->id)->get();
                @endphp
                @foreach ($subcategories as $subcategory)
                  <li>
                    <a href="{{ route('blogs.subcategory', ['categoryslug' => $row->slug, 'subcategoryslug' => $subcategory->slug]) }}"
                       class="block px-4 py-2 hover:bg-gray-100 text-sm">
                      {{ $subcategory->name }}
                    </a>
                  </li>
                @endforeach
              </ul>
            </div>
          </div>
        @endforeach
      </nav>

      <!-- Search (desktop only) -->
      <div class="hidden md:flex items-center">
        <form class="relative">
          <input type="text" name="search" placeholder="Search..."
                 class="pl-10 pr-4 py-2 rounded-full bg-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500">
          <button type="submit" class="absolute left-3 top-2.5 text-gray-500" aria-hidden="true">
            <!-- small search icon -->
            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M21 21l-4.35-4.35M11 19a8 8 0 100-16 8 8 0 000 16z" />
            </svg>
          </button>
        </form>
      </div>

      <!-- Mobile menu button (SVG hamburger, guaranteed visible) -->
      <button id="mobile-menu-button"
              class="md:hidden p-2 rounded-md text-white hover:bg-white focus:outline-none"
              aria-label="Open menu" aria-expanded="false">
        <!-- inline SVG hamburger -->
        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
        </svg>
      </button>
    </div>
  </div>

  <!-- Overlay for mobile menu -->
  <div id="mobile-overlay" class="fixed inset-0 bg-black/40 opacity-0 pointer-events-none transition-opacity duration-300 z-40"></div>

  <!-- Mobile Slide-in Menu -->
  <aside id="mobile-menu"
         class="fixed top-0 left-0 w-64 h-full bg-white shadow-lg transform -translate-x-full transition-transform duration-300 ease-in-out z-50">
    <div class="p-4 flex justify-between items-center border-b">
      <span class="font-semibold">Menu</span>
      <button id="mobile-menu-close" class="p-2 rounded-md hover:bg-gray-100 focus:outline-none" aria-label="Close menu">
        <!-- close X SVG -->
        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
        </svg>
      </button>
    </div>

    <nav class="p-4 space-y-4 overflow-auto h-[calc(100%-64px)]">
      <a href="{{ route('index') }}" class="block hover:text-blue-500"><!-- home line --> Home</a>

      @foreach($categories as $row)
        <div>
          <p class="font-medium">{{ $row->name }}</p>
          <ul class="ml-4 space-y-1">
            @php
              $subcategories = \App\Models\SubCategory::select('id','name','slug')
                  ->where('category_id', $row->id)->get();
            @endphp
            @foreach ($subcategories as $subcategory)
              <li>
                <a href="{{ route('blogs.subcategory', ['categoryslug' => $row->slug, 'subcategoryslug' => $subcategory->slug]) }}"
                   class="block hover:text-blue-500">
                  {{ $subcategory->name }}
                </a>
              </li>
            @endforeach
          </ul>
        </div>
      @endforeach
    </nav>
  </aside>
</header>

<!-- Mobile Menu Toggle Script -->
<script>
  (function () {
    const mobileBtn = document.getElementById('mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu');
    const closeBtn = document.getElementById('mobile-menu-close');
    const overlay = document.getElementById('mobile-overlay');

    if (!mobileBtn || !mobileMenu) return;

    function openMenu() {
      mobileMenu.classList.remove('-translate-x-full');
      overlay.classList.remove('opacity-0', 'pointer-events-none');
      overlay.classList.add('opacity-100');
      mobileBtn.setAttribute('aria-expanded', 'true');
      document.body.style.overflow = 'hidden'; // prevent background scroll
    }

    function closeMenu() {
      mobileMenu.classList.add('-translate-x-full');
      overlay.classList.add('opacity-0', 'pointer-events-none');
      overlay.classList.remove('opacity-100');
      mobileBtn.setAttribute('aria-expanded', 'false');
      document.body.style.overflow = ''; // restore
    }

    mobileBtn.addEventListener('click', openMenu);
    closeBtn.addEventListener('click', closeMenu);
    overlay.addEventListener('click', closeMenu);

    // optional: close on ESC
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') closeMenu();
    });
  })();
</script>
