<!doctype html>
<html class="no-js" lang="en">
    @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<head>
    <meta charset="utf-8">
    <meta name="verify-admitad" content="b5de719bdb" />
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    @yield('meta-content')
    <meta name="viewport" content="width=device-width, initial-scale=1">

     <link rel="shortcut icon" type="image/x-admin-icon" href="@if($settings){{ asset('admin-assets/images/logos') }}/{{$settings->favicon}}@endif">
    <!-- Place favicon.ico in the root directory -->
    
    <!-- CSS here -->
    <script src="https://cdn.tailwindcss.com"></script>
    @yield('custom-styles')
    
   <link rel="canonical" href="{{url()->current()}}"/>
</head>

<body>
   
   
    <!-- header-area -->
    @include('user.includes.header')


    <!-- header-area-end -->


        @yield('content')

   

    <!-- footer-area -->
    @include('user.includes.footer')

    <!-- JS here -->

    @include('user.includes.scripts')
    
    @yield('custom-scripts')
    <script>
         $(document).on('keyup', '.search-input', function() {
            var keyword = $('.search-input').val();
            console.log(keyword);
            $.ajax({
                type: 'GET',
                url: "{{ route('get-blogs') }}",
                data: {
                    key: keyword
                },
                success: function(resp) {
                    console.log(resp);
                    $('.autocomplete').css('display', 'block');
                    $('.autocomplete').html(resp);
                },
                error: function(resp) {
                    console.log(resp);
                }
            });
        });
    </script>
   

</body>

</html>
