@extends('user.layouts.app')

@section('custom-styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css" />
@endsection

@section('meta-content')
<title>{{ $blog->title }}</title>
<meta name="description" content="{{ $blog->meta_description }}">
<meta name="title" content="{{ $blog->meta_title }}">
@endsection

@section('content')
<!-- Breadcrumb -->
<nav class="bg-gray-100 py-3 px-5 rounded my-4 container mx-auto max-w-7xl" aria-label="breadcrumb">
  <ol class="flex space-x-2 text-gray-600 text-sm">
    <li><a href="{{ route('index') }}" class="text-blue-600 hover:underline">Home</a></li>
    <li>/</li>
    <li><a href="#" class="hover:underline text-blue-600">{{ $blog->category->name }}</a></li>
    <li>/</li>
    <li><a href="#" class="hover:underline text-blue-600">{{ $blog->sub_category->name }}</a></li>
    <li>/</li>
    <li class="font-semibold text-gray-800 truncate max-w-xs">{{ $blog->title }}</li>
  </ol>
</nav>

<section class="container mx-auto max-w-7xl px-4 lg:px-8 mb-16">
  <div class="flex flex-col lg:flex-row gap-12">

    <!-- Blog Content -->
    <article class="flex-1 bg-white rounded shadow p-6">
      <img src="{{ asset('admin-assets/images/blogs/' . $blog->feature_image) }}" alt="{{ $blog->title }}" class="w-full rounded mb-6 object-cover max-h-96" />
      <h1 class="text-3xl font-bold mb-2">{{ $blog->title }}</h1>
      
      <div class="prose max-w-none">
        {!! $blog->description !!}
      </div>

      <!-- Comments Form -->
      <section class="mt-14">
        <h2 class="text-xl font-semibold mb-6">Leave a Comment</h2>
        <form id="comment_form" class="space-y-4" method="POST" action="{{ route('comment.store') }}">
          @csrf
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <input type="text" name="name" id="name" placeholder="Name" required class="border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
            <input type="email" name="email" id="email" placeholder="Email" required class="border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
          </div>
          <input type="text" name="phone" placeholder="Phone" required class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
          <input type="text" name="subject" placeholder="Subject" required class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
          <textarea name="message" id="message" rows="6" placeholder="Comment" required class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"></textarea>
          <button id="comment_form_btn" type="submit" class="bg-blue-600 text-white px-6 py-3 rounded hover:bg-blue-700 transition">
            Post Comment
          </button>
        </form>
      </section>
    </article>

    <!-- Sidebar -->
    <aside class="w-full lg:w-80 space-y-6">
      <section class="bg-white rounded shadow p-6">
       <!-- admitad.banner: s98mwn83hhb5de719bdb7801e98dae Global YO WW -->
<a target="_blank" rel="nofollow" href="https://zmgig.com/g/s98mwn83hhb5de719bdb7801e98dae/?i=4"><img width="175" height="570" border="0" src="https://ad.admitad.com/b/s98mwn83hhb5de719bdb7801e98dae/" alt="Global YO WW"/></a>
<!-- /admitad.banner -->
<br>
<!-- admitad.banner: pafs5cm8m8b5de719bdb7801e98dae Global YO WW -->
<a target="_blank" rel="nofollow" href="https://zmgig.com/g/pafs5cm8m8b5de719bdb7801e98dae/?i=4"><img width="160" height="600" border="0" src="https://ad.admitad.com/b/pafs5cm8m8b5de719bdb7801e98dae/" alt="Global YO WW"/></a>
<!-- /admitad.banner -->
      </section>
    </aside>

  </div>
</section>
@endsection

@section('custom-scripts')
<script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>
<script>
  $('#comment_form').on('submit', function(e) {
    e.preventDefault();

    let form = this;
    let data = new FormData(form);

    $.ajax({
      url: form.action,
      method: form.method,
      data: data,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(response) {
        if (response.errors) {
          let errorMsg = '';
          $.each(response.errors, function(field, errors) {
            $.each(errors, function(i, error) {
              errorMsg += error + '<br>';
            });
          });
          iziToast.error({
            title: 'Error',
            message: errorMsg,
            position: 'topRight'
          });
        } else {
          iziToast.success({
            title: 'Success',
            message: response.success,
            position: 'topRight'
          });
          form.reset();
          // Optionally reload or update comments section here
          // $("#comments-section").load(location.href + " #comments-section");
        }
      },
      error: function(xhr, status, error) {
        iziToast.error({
          title: 'Error',
          message: 'An unexpected error occurred: ' + error,
          position: 'topRight'
        });
      }
    });
  });

  // Similar AJAX logic for reply, like, delete etc. can be modularized similarly
</script>
@endsection
