@extends('user.layouts.app')

@section('meta-content')
@php
    $settings = \App\Models\GeneralSetting::find(1);
@endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection

@section('content')

<!-- Breadcrumb -->
<nav class="bg-gray-100 py-3 px-5 rounded my-4" aria-label="Breadcrumb">
  <ol class="list-reset flex text-gray-600 space-x-2">
    <li><a href="{{ route('index') }}" class="hover:underline text-blue-600">Home</a></li>
    <li>/</li>
    <li aria-current="page" class="font-semibold text-gray-800">{{ $category->name }}</li>
  </ol>
</nav>

<!-- Main Content -->
<section class="container mx-auto px-4 lg:px-8">
  <div class="flex flex-col lg:flex-row lg:space-x-8">
    
    <!-- Left: Blog Posts -->
    <main class="flex-1 space-y-10">
      @foreach ($subcategories as $subcategory)
      <section>
        <h2 class="text-2xl font-bold mb-6 border-b-2 border-blue-600 inline-block pb-1">
          {{ $subcategory->name }}
        </h2>
        
        @php
          $categoryblogs = \App\Models\Blog::with(['category:id,name', 'sub_category:id,name'])
            ->inRandomOrder()
            ->where('blogs.sub_category_id', $subcategory->id)
            ->get();
        @endphp
        
        <div class="space-y-8">
          @foreach ($categoryblogs as $row)
          <article class="flex flex-col md:flex-row bg-white shadow-md rounded-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
            <a href="{{ route('blog.details', $row->slug) }}" class="md:w-1/3 block relative group overflow-hidden">
              <img src="{{ asset('admin-assets/images/blogs/' . $row->feature_image) }}" alt="{{ $row->title }}" class="object-cover w-full h-48 md:h-full group-hover:scale-105 transition-transform duration-300" />
              <span class="absolute top-2 left-2 bg-blue-600 text-white text-xs font-semibold px-3 py-1 rounded">
                {{ $row->sub_category->name }}
              </span>
            </a>
            <div class="md:w-2/3 p-6 flex flex-col justify-between">
              <div>
                <h3 class="text-xl font-semibold mb-2">
                  <a href="{{ route('blog.details', $row->slug) }}" class="hover:text-blue-600 transition-colors">
                    {{ $row->title }}
                  </a>
                </h3>
                
                <p class="text-gray-700">
                  {!! \Illuminate\Support\Str::limit(strip_tags($row->description), 300) !!}
                </p>
              </div>
            </div>
          </article>
          @endforeach
        </div>
      </section>
      @endforeach
    </main>

    <!-- Right Sidebar -->
    <aside class="w-full lg:w-80 mt-12 lg:mt-0 space-y-10">

      <!-- Categories Widget -->
      <section class="bg-white shadow-md rounded-lg p-6">
        <h3 class="text-xl font-bold mb-6 border-b-2 border-blue-600 inline-block pb-1">Categories</h3>
        <ul class="space-y-4">
          @foreach ($categories as $cat)
          <li>
            <a href="{{ route('blogs.category', $cat->slug) }}" class="flex items-center space-x-4 hover:text-blue-600 transition-colors">
              <img src="{{ asset('admin-assets/images/categories/' . $cat->feature_image) }}" alt="{{ $cat->name }}" class="w-12 h-12 object-cover rounded" />
              <span class="font-medium">{{ $cat->name }}</span>
            </a>
          </li>
          @endforeach
        </ul>
      </section>

      <!-- Newsletter Widget -->
      <section class="bg-white shadow-md rounded-lg p-6 text-center">
        <h3 class="text-xl font-bold mb-4 border-b-2 border-blue-600 inline-block pb-1">Newsletter</h3>
        <p class="text-gray-700 mb-6">Subscribe to our newsletter for the latest updates and exclusive deals.</p>
        <form action="#" method="post" class="flex flex-col space-y-4">
          <input type="email" name="email" required placeholder="Your email address" class="px-4 py-3 border rounded focus:outline-none focus:ring-2 focus:ring-blue-600" />
          <button type="submit" class="bg-blue-600 text-white py-3 rounded hover:bg-blue-700 transition-colors font-semibold">Subscribe</button>
        </form>
      </section>

      <!-- Banner Ad -->
      <section>
        <img src="{{ asset('user-assets/images/banner-ads/ad-sidebar.png') }}" alt="Advertisement" class="rounded shadow-md" />
      </section>

    </aside>

  </div>
</section>

@endsection
