@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('custom-styles')
@endsection
@section('content')
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('index')}}">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javasript">Forex & Crypto</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <section class="utf_block_wrapper">
        <div class="container">
          <div class="row">
                <div class="col-lg-8 col-md-12">
                    <!-- TradingView Widget BEGIN -->
                    <div class="tradingview-widget-container">
                        <div class="tradingview-widget-container__widget"></div>
                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow"
                                target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                            {
                                "symbols": [{
                                        "proName": "FOREXCOM:SPXUSD",
                                        "title": "S&P 500 Index"
                                    },
                                    {
                                        "proName": "FOREXCOM:NSXUSD",
                                        "title": "US 100 Cash CFD"
                                    },
                                    {
                                        "proName": "FX_IDC:EURUSD",
                                        "title": "EUR to USD"
                                    },
                                    {
                                        "proName": "BITSTAMP:BTCUSD",
                                        "title": "Bitcoin"
                                    },
                                    {
                                        "proName": "BITSTAMP:ETHUSD",
                                        "title": "Ethereum"
                                    }
                                ],
                                "showSymbolLogo": true,
                                "isTransparent": false,
                                "displayMode": "compact",
                                "colorTheme": "dark",
                                "locale": "en"
                            }
                        </script>
                    </div>
                    <!-- TradingView Widget END -->

                    <section class="blog-details-area pt-60 pb-60">
                        <div class="container">
                            <div class="section-title-wrap mb-30">
                                <div class="section-title">
                                    <h2 class="title">Forex Cross Rates</h2>
                                </div>
                                <div class="section-title-line"></div>
                            </div>
                            <!-- TradingView Widget BEGIN -->
                            <div class="tradingview-widget-container">
                                <div class="tradingview-widget-container__widget"></div>
                                <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/"
                                        rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on
                                            TradingView</span></a></div>
                                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-forex-cross-rates.js"
                                    async>
                                    {
                                        "width": "100%",
                                        "height": "50%",
                                        "currencies": [
                                            "EUR",
                                            "USD",
                                            "JPY",
                                            "GBP",
                                            "CHF",
                                            "AUD",
                                            "CAD",
                                            "NZD",
                                            "CNY",
                                            "TRY",
                                            "SEK",
                                            "NOK",
                                            "DKK",
                                            "ZAR",
                                            "HKD",
                                            "SGD",
                                            "THB",
                                            "MXN",
                                            "IDR",
                                            "KRW",
                                            "PLN",
                                            "ISK",
                                            "KWD",
                                            "PHP",
                                            "MYR",
                                            "INR",
                                            "TWD",
                                            "SAR",
                                            "AED",
                                            "RUB",
                                            "ILS",
                                            "ARS",
                                            "CLP",
                                            "COP",
                                            "PEN",
                                            "UYU"
                                        ],
                                        "isTransparent": false,
                                        "colorTheme": "dark",
                                        "locale": "en"
                                    }
                                </script>
                            </div>
                            <!-- TradingView Widget END -->
                            <div class="section-title-wrap mb-30">
                                <div class="section-title">
                                    <h2 class="title">Crypto Rates</h2>
                                </div>
                                <div class="section-title-line"></div>
                            </div>
                            <!-- TradingView Widget BEGIN -->
                            <div class="tradingview-widget-container">
                                <div class="tradingview-widget-container__widget"></div>
                                <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-screener.js" async>
                                {
                                "defaultColumn": "overview",
                                "screener_type": "crypto_mkt",
                                "displayCurrency": "USD",
                                "colorTheme": "dark",
                                "isTransparent": false,
                                "locale": "en",
                                "width": "100%",
                                "height": "80%"
                            }
                                </script>
                            </div>
                            <!-- TradingView Widget END -->
                        </div>
                    </section>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="sidebar-wrap panel vstack gap-2 pb-2" data-uc-sticky="end: .content-wrap; offset: 150; media: @m;">
                        <div class="widget ad-widget vstack gap-2 text-center p-2 border">
                            <div class="widgt-content">
                                <a class="cstack max-w-300px mx-auto text-none" href="https://themeforest.net/user/reacthemes/portfolio" target="_blank" rel="nofollow">
                                    <img class="d-block dark:d-none" src="../assets/images/common/ad-slot-aside.jpg" alt="Ad slot">
                                    <img class="d-none dark:d-block" src="../assets/images/common/ad-slot-aside-2.jpg" alt="Ad slot">
                                </a>
                            </div>
                        </div>
                        <!-- TradingView Widget BEGIN -->
                            <div class="tradingview-widget-container">
                                <div class="tradingview-widget-container__widget"></div>
                                <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
                                {
                                "displayMode": "regular",
                                "feedMode": "all_symbols",
                                "colorTheme": "dark",
                                "isTransparent": false,
                                "locale": "en",
                                "width": 300,
                                "height": 500
                            }
                                </script>
                            </div>
                            <!-- TradingView Widget END -->
                        
                    </div>
                </div> 
            </div>
        </div>
    </section>
    
@endsection
@section('custom-scripts')
@endsection
