@extends('user.layouts.app')

@section('meta-content')
@php
    $settings = \App\Models\GeneralSetting::find(1);
@endphp
<title>{{ $settings?->site_title ?? 'Site Title' }}</title>
<meta name="description" content="{{ $settings?->meta_description ?? '' }}">
<meta name="title" content="{{ $settings?->meta_title ?? '' }}">
@endsection

@section('custom-styles')
<!-- No custom CSS needed, using Tailwind only -->
@endsection

@section('content')
<!-- breadcrumb-area -->
<div class="bg-indigo-600 text-white py-4">
  <div class="container mx-auto px-4">
    <nav class="text-sm" aria-label="Breadcrumb">
      <ol class="list-reset flex space-x-2">
        <li><a href="{{ route('index') }}" class="hover:underline">Home</a></li>
        <li><span> / </span></li>
        <li><a href="javascript:;" class="hover:underline">Blogs</a></li>
        <li><span> / </span></li>
        <li class="font-semibold" aria-current="page">{{ $store->slug }}</li>
      </ol>
    </nav>
  </div>
</div>
<!-- breadcrumb-area-end -->

<div class="container mx-auto px-4 my-12">
  <div class="flex flex-col lg:flex-row gap-10">
    <!-- Sidebar -->
    <aside class="w-full lg:w-1/4 bg-white rounded-xl p-6 shadow-md sticky top-24 self-start">
      <img src="{{ asset('admin-assets/images/stores/' . $store->feature_image) }}" alt="{{ $store->name }}" class="w-36 mx-auto rounded-lg object-contain mb-6">
      <p class="text-gray-900 font-semibold mb-2 text-center">{{ $store->name }}</p>
      <p class="text-gray-700 text-sm text-justify">{{ $store->description }}</p>
    </aside>

    <!-- Main content -->
    <main class="w-full lg:w-3/4">
      @php
          $featured_coupon = $coupons->shift();
      @endphp

      @if($featured_coupon)
      <div class="bg-gradient-to-r from-indigo-600 to-indigo-500 rounded-2xl p-8 mb-12 shadow-lg text-white">
        <h2 class="text-3xl font-bold mb-3 select-none">🔥 {{ $featured_coupon->title }}</h2>
        <p class="text-indigo-100 mb-6">{{ $featured_coupon->description }}</p>
        <button
          type="button"
          class="bg-white text-indigo-600 font-semibold px-6 py-3 rounded-full shadow-md hover:bg-indigo-50 transition select-none"
          data-code="{{ $featured_coupon->code }}"
          data-url="{{ $featured_coupon->url }}"
          id="featured-copy-btn"
        >
          @if($featured_coupon->code) {{ $featured_coupon->code }} @else Get Deal @endif
        </button>
      </div>
      @endif

      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach ($coupons as $coupon)
        <div class="bg-white rounded-xl p-6 shadow hover:shadow-lg transition flex flex-col justify-between">
          <h3 class="text-lg font-semibold text-gray-900 mb-3 select-none">{{ $coupon->title }}</h3>
          <p class="text-gray-600 flex-grow mb-5">{{ $coupon->description }}</p>
          <button
            type="button"
            class="bg-indigo-600 text-white font-semibold px-5 py-2 rounded-full shadow hover:bg-indigo-700 transition select-none"
            data-code="{{ $coupon->code }}"
            data-url="{{ $coupon->url }}"
          >
            @if($coupon->code) {{ $coupon->code }} @else Get Deal @endif
          </button>
        </div>
        @endforeach
      </div>
    </main>
  </div>
</div>
@endsection

@section('custom-scripts')
<script src="{{ asset('user-assets/js/clipboard.min.js') }}" type="text/javascript"></script>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const clipboard = new ClipboardJS('button[data-code]');

    clipboard.on('success', function(e) {
      alert(`Copied: "${e.text}"`);
      e.clearSelection();
    });

    clipboard.on('error', function(e) {
      alert('Failed to copy! Please copy manually.');
    });
  });
</script>
@endsection
