
<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\GeneralSetting::find(1);
?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Breadcrumb -->
<nav class="bg-gray-100 py-3 px-5 rounded my-4" aria-label="breadcrumb">
  <ol class="flex space-x-2 text-gray-600">
    <li><a href="<?php echo e(route('index')); ?>" class="text-blue-600 hover:underline">Home</a></li>
    <li>/</li>
    <li><a href="#" class="hover:underline text-blue-600"><?php echo e($category->name); ?></a></li>
    <li>/</li>
    <li class="font-semibold text-gray-800" aria-current="page"><?php echo e($subcategory->name); ?></li>
  </ol>
</nav>

<!-- Main Section -->
<section class="container mx-auto px-4 lg:px-8">
  <div class="flex flex-col lg:flex-row lg:space-x-10">

    <!-- Blog List -->
    <main class="flex-1 space-y-8">
      <h2 class="text-2xl font-bold border-b-4 border-blue-600 pb-2 mb-6"><?php echo e($subcategory->name); ?></h2>
      
      <?php $__currentLoopData = $blogsbysubcategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="flex flex-col md:flex-row bg-white shadow rounded-lg overflow-hidden hover:shadow-lg transition-shadow duration-300">
        <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="md:w-1/3 block overflow-hidden group">
          <img src="<?php echo e(asset('admin-assets/images/blogs/' . $row->feature_image)); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300" />
        </a>
        <div class="md:w-2/3 p-6 flex flex-col justify-between">
          <div>
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="block text-xl font-semibold text-gray-900 hover:text-blue-600 transition-colors mb-3">
              <?php echo e($row->title); ?>

            </a>
            <p class="text-gray-700 mb-4"><?php echo \Illuminate\Support\Str::limit(strip_tags($row->description), 150); ?></p>
          </div>
          <div class="flex items-center justify-between text-sm text-gray-500">
           
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="flex items-center text-blue-600 hover:underline font-semibold">
              Read More <img src="<?php echo e(asset('user-assets/images/arrow.png')); ?>" alt="arrow" class="ml-1 w-4 h-4" />
            </a>
          </div>
        </div>
      </article>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>

    <!-- Sidebar -->
    <aside class="w-full lg:w-80 mt-10 lg:mt-0">
      <section class="bg-white shadow rounded-lg p-6">
        <h3 class="text-xl font-bold mb-6 border-b-2 border-blue-600 pb-1">Categories</h3>
        <ul class="space-y-4">
          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="flex items-center space-x-4">
            <a href="<?php echo e(route('blogs.category', $category->slug)); ?>">
              <img src="<?php echo e(asset('admin-assets/images/categories/' . $category->feature_image)); ?>" alt="<?php echo e($category->name); ?>" class="w-16 h-16 object-cover rounded" />
            </a>
            <a href="<?php echo e(route('blogs.category', $category->slug)); ?>" class="text-gray-800 font-medium hover:text-blue-600 transition-colors">
              <?php echo e($category->name); ?>

            </a>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </section>
    </aside>

  </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mdwdigizhb/postprospectors.com/resources/views/user/pages/blogs-by-subcategory.blade.php ENDPATH**/ ?>