
<?php $__env->startSection('custom-styles'); ?>
    <!-- Bootstrap Select Css -->
    <link href="<?php echo e(asset('admin-assets/css/bootstrap-select.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Sub Category</h2>
                    
                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <?php if(count($errors) > 0): ?>
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('subcategories.store')); ?>" autocomplete="off" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <label class="form-label">Parent Category</label>
                        <select class="form-control show-tick" name="category_id">
                            <option value="">--select Category--</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($category); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Category Name"
                                value="<?php echo e(old('name')); ?>" name="name" required>
                            
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="feature_image">
                            
                        </div>
                        <label for="logo_image">Logo Image</label>
                        <div class="form-group">
                            <input type="file" id="logo_image" class="form-control" name="logo_image">
                            
                        </div>
                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="<?php echo e(route('subcategories.index')); ?>" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/postprospectors.com/resources/views/admin/pages/subcategories/create.blade.php ENDPATH**/ ?>