

<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\GeneralSetting::find(1);
?>
<title><?php echo e($settings?->site_title ?? 'Site Title'); ?></title>
<meta name="description" content="<?php echo e($settings?->meta_description ?? ''); ?>">
<meta name="title" content="<?php echo e($settings?->meta_title ?? ''); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-styles'); ?>
<!-- No custom CSS needed, using Tailwind only -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- breadcrumb-area -->
<div class="bg-indigo-600 text-white py-4">
  <div class="container mx-auto px-4">
    <nav class="text-sm" aria-label="Breadcrumb">
      <ol class="list-reset flex space-x-2">
        <li><a href="<?php echo e(route('index')); ?>" class="hover:underline">Home</a></li>
        <li><span> / </span></li>
        <li><a href="javascript:;" class="hover:underline">Blogs</a></li>
        <li><span> / </span></li>
        <li class="font-semibold" aria-current="page"><?php echo e($store->slug); ?></li>
      </ol>
    </nav>
  </div>
</div>
<!-- breadcrumb-area-end -->

<div class="container mx-auto px-4 my-12">
  <div class="flex flex-col lg:flex-row gap-10">
    <!-- Sidebar -->
    <aside class="w-full lg:w-1/4 bg-white rounded-xl p-6 shadow-md sticky top-24 self-start">
      <img src="<?php echo e(asset('admin-assets/images/stores/' . $store->feature_image)); ?>" alt="<?php echo e($store->name); ?>" class="w-36 mx-auto rounded-lg object-contain mb-6">
      <p class="text-gray-900 font-semibold mb-2 text-center"><?php echo e($store->name); ?></p>
      <p class="text-gray-700 text-sm text-justify"><?php echo e($store->description); ?></p>
    </aside>

    <!-- Main content -->
    <main class="w-full lg:w-3/4">
      <?php
          $featured_coupon = $coupons->shift();
      ?>

      <?php if($featured_coupon): ?>
      <div class="bg-gradient-to-r from-indigo-600 to-indigo-500 rounded-2xl p-8 mb-12 shadow-lg text-white">
        <h2 class="text-3xl font-bold mb-3 select-none">🔥 <?php echo e($featured_coupon->title); ?></h2>
        <p class="text-indigo-100 mb-6"><?php echo e($featured_coupon->description); ?></p>
        <button
          type="button"
          class="bg-white text-indigo-600 font-semibold px-6 py-3 rounded-full shadow-md hover:bg-indigo-50 transition select-none"
          data-code="<?php echo e($featured_coupon->code); ?>"
          data-url="<?php echo e($featured_coupon->url); ?>"
          id="featured-copy-btn"
        >
          <?php if($featured_coupon->code): ?> <?php echo e($featured_coupon->code); ?> <?php else: ?> Get Deal <?php endif; ?>
        </button>
      </div>
      <?php endif; ?>

      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
        <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white rounded-xl p-6 shadow hover:shadow-lg transition flex flex-col justify-between">
          <h3 class="text-lg font-semibold text-gray-900 mb-3 select-none"><?php echo e($coupon->title); ?></h3>
          <p class="text-gray-600 flex-grow mb-5"><?php echo e($coupon->description); ?></p>
          <button
            type="button"
            class="bg-indigo-600 text-white font-semibold px-5 py-2 rounded-full shadow hover:bg-indigo-700 transition select-none"
            data-code="<?php echo e($coupon->code); ?>"
            data-url="<?php echo e($coupon->url); ?>"
          >
            <?php if($coupon->code): ?> <?php echo e($coupon->code); ?> <?php else: ?> Get Deal <?php endif; ?>
          </button>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </main>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts'); ?>
<script src="<?php echo e(asset('user-assets/js/clipboard.min.js')); ?>" type="text/javascript"></script>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const clipboard = new ClipboardJS('button[data-code]');

    clipboard.on('success', function(e) {
      alert(`Copied: "${e.text}"`);
      e.clearSelection();
    });

    clipboard.on('error', function(e) {
      alert('Failed to copy! Please copy manually.');
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/postprospectors.com/resources/views/user/pages/store-profile.blade.php ENDPATH**/ ?>