
<?php $__env->startSection('custom-styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
<title><?php echo e($blog->title); ?></title>
<meta name="description" content="<?php echo e($blog->meta_description); ?>">
<meta name="title" content="<?php echo e($blog->meta_title); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- breadcrumb-area -->
<div class="page-title">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <ul class="breadcrumb">
               <li><a href="<?php echo e(route('index')); ?>">Home</a></li>
               <li><a href=""><?php echo e($blog->category->name); ?></a></li>
               <li><a href=""><?php echo e($blog->sub_category->name); ?></a></li>
               <li><a href=""><?php echo e($blog->slug); ?></a></li>
            </ul>
         </div>
      </div>
   </div>
</div>
<!-- breadcrumb-area-end -->
<!-- banner-post-area -->
<section class="utf_block_wrapper">
   <div class="container">
      <div class="row">
            <div class="col-lg-9 col-md-12">
                <div class="blog-box">
                    <div class="entry-cover">
                        <a href="#"><img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>" alt="single-post"></a>
                        <a id="add_sign_count-1" class="add-sign-big color-pink-red"><i class="fa fa-angle-down"></i></a>
                    </div>
            
                    <div class="blog-content">
                        <h2 class="entry-title"><?php echo e($blog->title); ?></h2>
                        <p class="time"><i class="fa fa-clock-o"></i> 1 Hour ago</p>
                        <p class="entry-content"><?php echo $blog->description; ?></p>
                        
                    </div>								
                    
                </div>
                
                <!-- Post comment end -->
                <!-- Comments Form Start -->
                <div class="comments-form">
                <h3 class="title-normal">Leave a comment</h3>
                <form>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                            <input class="form-control" name="name" id="name" placeholder="Name" type="text" required="">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                            <input class="form-control" name="email" id="email" placeholder="Email" type="email" required="">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                            <input class="form-control" placeholder="Phone" type="text" required="">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                            <input class="form-control" placeholder="Subject" type="text" required="">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                            <textarea class="form-control required-field" id="message" placeholder="Comment" rows="10" required=""></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix">
                        <button class="comments-btn btn btn-primary" type="submit">Post Comment</button>
                    </div>
                </form>
                </div>
                <!-- Comments form end -->           
            </div>
            <div class="col-md-3 col-sm-6 widget-sidebar">
                <!-- Latest Post -->
                <aside class="widget widget_latest_post">
                <h3 class="widget-title">Categories</h3>
                <div class="widget-inner">
                    <ul class="post">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="col-md-5 col-sm-5 col-xs-4">
                            <a href="#"><img src="<?php echo e(asset('admin-assets/images/categories')); ?>/<?php echo e($category->feature_image); ?>" alt="popular-post"></a>
                            </div>
                            <div class="col-md-7 col-sm-7 col-xs-8">
                            <a href="<?php echo e(route('blogs.category', $category->slug)); ?>" class="post-title"><?php echo e($category->name); ?></a>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                </aside>
                <!-- Latest Post /- -->
            </div>
      </div>
   </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>
<script>
   $("#comment_form_btn").click(function(e) {
       e.preventDefault();
       let form = $('#comment_form')[0];
       let data = new FormData(form);
   
       $.ajax({
           url: "<?php echo e(route('comment.store')); ?>",
           type: "POST",
           data: data,
           dataType: "JSON",
           processData: false,
           contentType: false,
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: 'Comment Failed',
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '.reply_btn', function() {
       var comment_id = $(this).data('comment_id');
       var comment_id = $(this).data('user_id');
       // var html = ``;
       $(this).css('display', 'none');
       $(this).closest('.comments-text').find('.reply-section').css('display', 'block');
       $(this).closest('.comments-text').find('.cancelli').css('display', 'block');
   
   });
   
   $(document).on('click', '.cancel_btn', function() {
       var comment_id = $(this).data('comment_id');
       var comment_id = $(this).data('user_id');
       // var html = ``;
       $(this).closest('.comments-text').find('.cancelli').css('display', 'none');
       $(this).closest('.comments-text').find('.reply-section').css('display', 'none');
       $(this).closest('.comments-text').find('.reply_btn').css('display', 'block');
   
   });
   
   $(".reply_form_btn").click(function(e) {
       e.preventDefault();
       let form = $(this).closest('.comments-text').find('.reply_form')[0];
       let data = new FormData(form);
   
       $.ajax({
           url: "<?php echo e(route('reply.store')); ?>",
           type: "POST",
           data: data,
           dataType: "JSON",
           processData: false,
           contentType: false,
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: 'Comment Failed',
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#like_comment_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var comment_id = $(this).data('comment_id');
       console.log(comment_id);
       $.ajax({
           url: "<?php echo e(route('comment.like')); ?>",
           type: "GET",
           data: {
               comment_id: comment_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#like_reply_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var reply_id = $(this).data('reply_id');
       console.log(reply_id);
       $.ajax({
           url: "<?php echo e(route('reply.like')); ?>",
           type: "GET",
           data: {
               reply_id: reply_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#dlt_comment_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var comment_id = $(this).data('comment_id');
       console.log(comment_id);
       $.ajax({
           url: "<?php echo e(route('comment.delete')); ?>",
           type: "GET",
           data: {
               comment_id: comment_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#dlt_reply_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var reply_id = $(this).data('reply_id');
   
       $.ajax({
           url: "<?php echo e(route('reply.delete')); ?>",
           type: "GET",
           data: {
               reply_id: reply_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#save_btn', function(e) {
       e.preventDefault();
   
       var blog_id = $(this).data('id');
       console.log(blog_id);
       $.ajax({
           url: "<?php echo e(route('blog.save')); ?>",
           type: "GET",
           data: {
               blog_id: blog_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#save-section").load(location.href + " #save-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/blog-details.blade.php ENDPATH**/ ?>