
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-styles'); ?>
   
<style>
   .sidebar {
      background: #f6f6f6;
      padding: 30px 20px;
      border-radius: 12px;
      height: 100%;
    }

    .featured-coupon {
      background: #edf0f8;
      border-left: 8px solid #6366f1;
      padding: 30px;
      border-radius: 16px;
      margin-bottom: 30px;
    }

    .featured-coupon h2 {
      font-weight: 700;
      color: #333;
    }

    .coupon-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 24px;
    }

    .coupon-card {
      background: #fff;
      border: 1px solid #e3e3e3;
      border-radius: 14px;
      padding: 20px;
      transition: 0.3s ease;
      position: relative;
    }

    .coupon-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 8px 16px rgba(0,0,0,0.06);
    }

    .coupon-title {
      font-weight: 600;
      font-size: 1.8rem;
      margin-bottom: 6px;
      color: #222;
    }

    .coupon-desc {
      color: #555;
      font-size: 1.4rem;
      margin-bottom: 12px;
    }

    .coupon-code-btn {
      background-color: #6366f1;
      color: white;
      font-weight: 600;
      padding: 6px 14px;
      border-radius: 10px;
      font-size: 0.875rem;
      border: none;
    }

    .brand-logo {
      width: 120px;
      margin-bottom: 15px;
    }

    @media (max-width: 768px) {
      .sidebar {
        margin-bottom: 30px;
      }
    }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Blogs</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e($store->slug); ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <div class="container my-5">
      <div class="row">
        <!-- Sidebar Info -->
        <div class="col-lg-3">
          <div class="sidebar">
            <img src="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" alt="<?php echo e($store->name); ?>" class="brand-logo">
            <p class="mb-2"><strong><?php echo e($store->name); ?></strong> is the go-to store for authentic fan gear, licensed jerseys, and collectibles.</p>
            <p><?php echo e($store->description); ?></p>
            <ul class="list-unstyled small">
             
            </ul>
          </div>
        </div>
  
        <!-- Main Content -->
        <div class="col-lg-9">
          <!-- Featured Coupon Banner -->
          <?php
            $featured_coupon = $coupons->shift();
          ?>
          <?php if($featured_coupon): ?>
          <div class="featured-coupon">
            <h2 class="mb-2">🔥 <?php echo e($featured_coupon->title); ?></h2>
            <p class="text-muted"><?php echo e($featured_coupon->description); ?></p>
            <a href="<?php echo e($featured_coupon->url); ?>" target="_blank" id="btn"
              data-title="<?php echo e($featured_coupon->title); ?>" data-des="<?php echo e($featured_coupon->description); ?>"
              data-code="<?php echo e($featured_coupon->code); ?>" data-url="<?php echo e($featured_coupon->url); ?>"
              data-coupon_id="<?php echo e($featured_coupon->id); ?>"
              data-img="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" data-clipboard-action="copy"
              data-clipboard-target="#code_text" class="coupon-code-btn mt-2"><?php if($featured_coupon->code): ?> <?php echo e($featured_coupon->code); ?> <?php else: ?> Get Deal <?php endif; ?></a>
          </div>
          <?php endif; ?>
          <!-- Grid of Other Coupons -->
          <div class="coupon-grid">
            <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="coupon-card">
              <div class="coupon-title"><?php echo e($row->title); ?></div>
              <div class="coupon-desc"><?php echo e($row->description); ?></div>
              <a href="<?php echo e($row->url); ?>" target="_blank" id="btn"
                data-title="<?php echo e($row->title); ?>" data-des="<?php echo e($row->description); ?>"
                data-code="<?php echo e($row->code); ?>" data-url="<?php echo e($row->url); ?>"
                data-coupon_id="<?php echo e($row->id); ?>"
                data-img="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" data-clipboard-action="copy"
                data-clipboard-target="#code_text" class="coupon-code-btn"><?php if($row->code): ?> <?php echo e($row->code); ?> <?php else: ?> Get Deal <?php endif; ?></a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
       
    </div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script src="<?php echo e(asset('user-assets/js/clipboard.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('user-assets/js/custom.js')); ?>" type="text/javascript"></script>
    <script>
        var btn = document.getElementById('btn');
        var clipboard = new ClipboardJS(btn);

        clipboard.on('success', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });

        clipboard.on('error', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/store-profile.blade.php ENDPATH**/ ?>