<!-- Footer Section -->
<footer class="bg-[#3F51B5] text-white pt-12">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-10">

      <!-- About Us -->
      <div>
        <h3 class="text-xl font-semibold mb-4">About us</h3>
        <img src="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos/'.$settings->footer_logo)); ?><?php endif; ?>" alt="Footer Logo" class="w-48 mb-4">

        <h4 class="text-lg font-semibold mb-2">Stay in touch</h4>
        <ul class="flex space-x-4 text-xl">
          <?php $social_links = \App\Models\SocialMedia::get(); ?>
          <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li>
            <a href="<?php echo e($link->url); ?>" title="<?php echo e($link->title); ?>" target="_blank" rel="noopener noreferrer"
               class="hover:text-blue-600 transition">
              <i class="fa fa-<?php echo e($link->title); ?>"></i>
            </a>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>

      <!-- Popular Categories -->
      <div>
        <h3 class="text-xl font-semibold mb-4">Popular Categories</h3>
        <ul class="space-y-4">
          <?php
            $categories = \App\Models\Category::select('id', 'slug', 'name', 'feature_image')->limit(5)->get();
          ?>
          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="flex items-center space-x-4">
            
            <a href="<?php echo e(route('blogs.category', $row->slug)); ?>" class="text-lg font-medium hover:text-blue-600 transition">
              <?php echo e($row->name); ?>

            </a>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>

      <!-- Newsletter Signup -->
      <div>
        <h3 class="text-xl font-semibold mb-4">Newsletter Signup</h3>
        <p class="mb-4 text-white">Sign up to our newsletter and get exclusive deals you will not find anywhere else straight to your inbox!</p>

        <form class="flex max-w-md" action="#" method="POST">
          <input type="email" name="email" placeholder="Enter your email"
                 class="flex-grow px-4 py-2 rounded-l-md border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500"
                 required>
          <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-r-md hover:bg-blue-700 transition flex items-center justify-center">
            <img src="<?php echo e(asset('user-assets/images/email-newsletter-icon.png')); ?>" alt="email icon" class="w-5 h-5">
          </button>
        </form>
      </div>
    </div>

    <!-- Footer Bottom -->
    <div class="border-t border-gray-300 mt-12 pt-6 pb-6 flex flex-col md:flex-row justify-between items-center text-sm text-white">
      <p class="mb-4 md:mb-0">
        &copy; <script>document.write(new Date().getFullYear())</script>
        <?php if($settings): ?> <?php echo e($settings->site_title); ?> <?php endif; ?>. All rights reserved.
      </p>

      <nav>
        <ul class="flex flex-wrap space-x-4">
          <?php $pages = \App\Models\Page::all(); ?>
          <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
              <a href="<?php echo e(route('page', $page->slug)); ?>" class="hover:text-blue-600 transition">
                <?php echo e($page->title); ?>

              </a>
            </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </nav>
    </div>
  </div>
</footer>
<?php /**PATH /home/dealqmki/postprospectors.com/resources/views/user/includes/footer.blade.php ENDPATH**/ ?>