

<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\GeneralSetting::find(1);
?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Latest Updates -->
<section aria-label="Latest Updates" class="container mx-auto px-4 py-6">
  <h3 class="text-xl font-semibold mb-4">Latest Updates</h3>

  <div class="flex space-x-6 overflow-x-auto scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-gray-100">
    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <a href="<?php echo e(route('blog.details', $row->slug)); ?>" 
         class="flex-shrink-0 w-64 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300 cursor-pointer overflow-hidden">
         
        <img src="<?php echo e(asset('admin-assets/images/blogs/' . $row->feature_image)); ?>" 
             alt="<?php echo e($row->title); ?>" 
             class="w-full h-40 object-cover rounded-t-lg" />

        <div class="p-4">
          <h4 class="text-lg font-semibold text-gray-900 mb-2 truncate"><?php echo e($row->title); ?></h4>
         
        </div>
      </a>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</section>
<div id="latest-articles" class="latest-articles my-10">
  <div class="container mx-auto px-4">
    <h2 class="text-2xl font-bold mb-6">Latest Articles</h2>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
      <?php $__currentLoopData = $category_blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $categblogs = \App\Models\Blog::where('category_id', $category->id)
                          ->where('status', 'publish')
                          ->inRandomOrder()
                          ->limit(4)
                          ->get();
          $excludedIds = $categblogs->pluck('id')->toArray();
          $categ_second_blogs = \App\Models\Blog::where('category_id', $category->id)
                                ->where('status', 'publish')
                                ->whereNotIn('id', $excludedIds)
                                ->inRandomOrder()
                                ->limit(3)
                                ->get();
        ?>
        <div class="widget-sidebar bg-white rounded-lg shadow-md p-4">
          <h3 class="text-xl font-semibold mb-4"><?php echo e($category->name); ?></h3>
          <ul class="space-y-4">
            <?php $__currentLoopData = $categblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="flex space-x-4 items-center">
              <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="flex-shrink-0 w-20 h-16 overflow-hidden rounded">
                <img src="<?php echo e(asset('admin-assets/images/blogs/'.$row->feature_image)); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-full object-cover">
              </a>
              <div>
                <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="post-title font-semibold text-gray-900 hover:text-blue-600">
                  <?php echo e($row->title); ?>

                </a>
                <p class="text-sm text-gray-500">
                  <span class="post-category"><?php echo e($row->category->name); ?></span> &nbsp;|&nbsp;
                  
                </p>
              </div>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</div>

<!-- Slider Section -->
<div id="slider-section" class="slider-section py-8 bg-gray-50">
  <div class="max-w-7xl mx-auto px-4">
    <div class="relative">
      <!-- Use a JS slider/carousel library here for production -->
      <div class="flex overflow-x-auto snap-x snap-mandatory gap-6 scrollbar-hide">
        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="snap-start flex-shrink-0 w-full md:w-1/2 lg:w-1/3 rounded-lg shadow-md bg-white overflow-hidden">
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>">
              <img src="<?php echo e(asset('admin-assets/images/blogs/'.$row->feature_image)); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-48 object-cover">
            </a>
            <div class="p-4">
              <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="block text-lg font-semibold text-gray-900 hover:text-blue-600 mb-2">
                <?php echo e($row->title); ?>

              </a>
              
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <!-- Arrows can be added here with JS controls -->
    </div>
  </div>
</div>

<!-- Adds -->
<div class="add-show my-8">
  <div class="container mx-auto px-4">
    <a href="#">
      <img src="<?php echo e(asset('user-assets/images/Laborday.jpg')); ?>" alt="Advertisement" class="w-full rounded-lg shadow-md" />
    </a>
  </div>
</div>

<!-- Posts Section -->
<div id="category-post-section" class="category-post-section my-10">
  <div class="container mx-auto px-4">
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
      <?php $__currentLoopData = $popblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="bg-white rounded-lg shadow-md overflow-hidden flex flex-col">
        <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="block overflow-hidden">
          <img src="<?php echo e(asset('admin-assets/images/blogs/'.$row->feature_image)); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-48 object-cover transition-transform duration-300 hover:scale-105" />
        </a>
        <div class="p-4 flex flex-col flex-grow">
          <span class="text-sm text-gray-500 mb-1"><?php echo e($row->category->name); ?></span>
          <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="text-lg font-semibold text-gray-900 hover:text-blue-600 flex-grow"><?php echo e($row->title); ?></a>
          
          <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="mt-4 inline-flex items-center text-blue-600 hover:underline font-semibold">
            Read More <img src="<?php echo e(asset('user-assets/images/arrow.png')); ?>" alt="arrow" class="ml-2 w-4 h-4">
          </a>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</div>

<!-- Popular Blogs Section -->
<div id="fashion-style-section" class="fashion-style-section my-10">
  <div class="container mx-auto px-4">
    <h2 class="text-2xl font-bold mb-6">Popular Blogs</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-6">
      <?php $__currentLoopData = $popularblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="bg-white rounded-lg shadow-md overflow-hidden flex flex-col">
        <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="block overflow-hidden">
          <img src="<?php echo e(asset('admin-assets/images/blogs/'.$row->feature_image)); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-48 object-cover transition-transform duration-300 hover:scale-105" />
        </a>
        <div class="p-4 flex flex-col flex-grow">
          <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="text-lg font-semibold text-gray-900 hover:text-blue-600 flex-grow"><?php echo e($row->title); ?></a>
          
          <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="mt-4 inline-flex items-center text-blue-600 hover:underline font-semibold">
            Read More <img src="<?php echo e(asset('user-assets/images/arrow.png')); ?>" alt="arrow" class="ml-2 w-4 h-4">
          </a>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</div>

<!-- Latest Articles -->


<!-- Ad Content Area -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>

<script>
  $("#subscribe_form_btn").click(function(e) {
    e.preventDefault();
    let form = $('#subscribe_form')[0];
    let data = new FormData(form);

    $.ajax({
      url: "<?php echo e(route('subscriber.store')); ?>",
      type: "POST",
      data: data,
      dataType: "JSON",
      processData: false,
      contentType: false,

      success: function(response) {
        if (response.errors) {
          var errorMsg = '';
          $.each(response.errors, function(field, errors) {
            $.each(errors, function(index, error) {
              errorMsg += error + '<br>';
            });
          });
          iziToast.error({
            message: 'Subscription Failed',
            position: 'topRight'
          });
        } else {
          iziToast.success({
            message: response.success,
            position: 'topRight'
          });

          $("#subscribe_form").load(location.href + " #subscribe_form");
        }
      },
      error: function(xhr, status, error) {
        iziToast.error({
          message: 'An error occurred: ' + error,
          position: 'topRight'
        });
      }
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mdwdigizhb/postprospectors.com/resources/views/user/pages/index.blade.php ENDPATH**/ ?>