

<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\GeneralSetting::find(1);
?>
<title><?php echo e($settings?->site_title ?? 'Site Title'); ?></title>
<meta name="description" content="<?php echo e($settings?->meta_description ?? ''); ?>">
<meta name="title" content="<?php echo e($settings?->meta_title ?? ''); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Breadcrumb Area -->
<nav class="bg-gray-100 py-4 mb-8" aria-label="breadcrumb">
  <div class="container mx-auto px-4 max-w-7xl">
    <ol class="flex space-x-2 text-gray-700 text-sm">
      <li>
        <a href="<?php echo e(route('index')); ?>" class="hover:text-blue-600">Home</a>
      </li>
      <li>/</li>
      <li class="font-semibold text-gray-900"><?php echo e($page->slug); ?></li>
    </ol>
  </div>
</nav>

<!-- Blog Details Area -->
<section class="container mx-auto px-4 max-w-7xl pb-16">
  <div class="flex flex-col lg:flex-row gap-12">

    <!-- Main Content -->
    <article class="flex-1 prose max-w-none">
      <h1 class="text-3xl font-bold mb-6"><?php echo e($page->title); ?></h1>
      <div class="text-gray-800 leading-relaxed">
        <?php echo $page->details; ?>

      </div>
    </article>

    <!-- Sidebar -->
    <aside class="w-full lg:w-96 space-y-8">

      <!-- Search Widget -->
      <div class="bg-white p-6 rounded shadow">
        <form action="#" method="GET" class="flex">
          <input
            type="text"
            name="search"
            placeholder="Search..."
            class="flex-grow px-4 py-2 border border-gray-300 rounded-l-md focus:outline-none focus:ring-2 focus:ring-blue-500"
          />
          <button
            type="submit"
            class="bg-blue-600 text-white px-4 rounded-r-md hover:bg-blue-700 transition"
            aria-label="Search"
          >
            <i class="flaticon-search"></i>
          </button>
        </form>
      </div>

      <!-- Recent News Widget -->
      <div class="bg-white p-6 rounded shadow">
        <h2 class="text-xl font-semibold mb-6 border-b-2 border-blue-600 pb-2">Recent News</h2>
        <div class="space-y-6">
          <?php
              $firstBlog = $blogs->shift();
          ?>
          <?php if($firstBlog): ?>
          <div class="flex flex-col md:flex-row gap-4">
            <a href="<?php echo e(route('blog.details', $firstBlog->slug)); ?>" class="flex-shrink-0 md:w-40 h-28 rounded overflow-hidden">
              <img
                src="<?php echo e(asset('admin-assets/images/blogs/' . $firstBlog->feature_image)); ?>"
                alt="<?php echo e($firstBlog->title); ?>"
                class="object-cover w-full h-full"
              />
            </a>
            <div>
              <a href="#" class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold px-3 py-1 rounded mb-2"><?php echo e($firstBlog->category->name); ?></a>
              <h3 class="text-lg font-semibold leading-tight">
                <a href="<?php echo e(route('blog.details', $firstBlog->slug)); ?>" class="hover:text-blue-600 transition"><?php echo e($firstBlog->title); ?></a>
              </h3>
              <ul class="flex text-gray-500 text-xs mt-2 space-x-4">
                <li><i class="flaticon-calendar mr-1"></i> <?php echo e($firstBlog->updated_at->toFormattedDateString()); ?></li>
                <li><i class="flaticon-history mr-1"></i> <?php echo e($firstBlog->updated_at->diffForHumans()); ?></li>
              </ul>
            </div>
          </div>
          <?php endif; ?>

          <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="border-t pt-4">
            <a href="#" class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold px-3 py-1 rounded mb-2"><?php echo e($row->category->name); ?></a>
            <h4 class="font-semibold text-base leading-snug mb-1">
              <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="hover:text-blue-600 transition"><?php echo e($row->title); ?></a>
            </h4>
            <ul class="flex text-gray-500 text-xs space-x-4">
              <li><i class="flaticon-calendar mr-1"></i> <?php echo e($row->updated_at->toFormattedDateString()); ?></li>
              <li><i class="flaticon-history mr-1"></i> <?php echo e($row->updated_at->diffForHumans()); ?></li>
            </ul>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>

      <!-- Newsletter Widget -->
      <div class="bg-white p-6 rounded shadow text-center">
        <div class="text-blue-600 mb-4 text-4xl">
          <i class="flaticon-envelope"></i>
        </div>
        <h3 class="text-xl font-semibold mb-2">Daily Newsletter</h3>
        <p class="mb-6 text-gray-600">Get all the top stories from Blogs to keep track.</p>
        <form id="subscribe_form" method="POST" action="#" class="space-y-4">
          <?php echo csrf_field(); ?>
          <input
            type="email"
            name="email"
            placeholder="Enter your e-mail"
            required
            class="w-full px-4 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
          />
          <div class="flex items-center space-x-2 text-sm">
            <input type="checkbox" id="checkbox" class="form-checkbox" required />
            <label for="checkbox" class="select-none">I agree to the terms & conditions</label>
          </div>
          <button
            id="subscribe_form_btn"
            type="submit"
            class="w-full bg-blue-600 text-white font-semibold py-2 rounded hover:bg-blue-700 transition"
          >
            Subscribe Now
          </button>
        </form>
      </div>

    </aside>
  </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/postprospectors.com/resources/views/user/pages/info-page.blade.php ENDPATH**/ ?>